package ml.pluto7073.chemicals.commands;

import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;

import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ConsumableChemicalHandler;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class ChemicalCommands {

	public static void register() {
		CommandRegistrationCallback.EVENT.register((dispatcher, context, selection) -> {
			LiteralArgumentBuilder<class_2168> chemicals = method_9247("chemicals");
			for (ConsumableChemicalHandler handler : Chemicals.REGISTRY) {
				if (handler.getId().method_12832().equals("empty")) continue;
				LiteralArgumentBuilder<class_2168> custom = handler.createCustomChemicalCommandExtension();
				chemicals.then(custom != null ? custom : createChemicalCommand(handler));
			}
			dispatcher.register(chemicals);
		});
	}

	private static LiteralArgumentBuilder<class_2168> createChemicalCommand(ConsumableChemicalHandler handler) {
		return method_9247(handler.getId().toString())
				.then(createGetCommand(handler))
				.then(createSetCommand(handler))
				.then(createChangeCommand(handler));
	}

	private static LiteralArgumentBuilder<class_2168> createGetCommand(ConsumableChemicalHandler handler) {
		return method_9247("get")
				.then(method_9244("target", class_2186.method_9305())
					.executes(ctx -> {
						class_3222 target = class_2186.method_9315(ctx, "target");
						String amount = handler.formatAmount(handler.get(target));
						ctx.getSource().method_9226(() ->
								class_2561.method_43469("command.chemical.get.response", target.method_5477(), amount,
										class_2561.method_43471(handler.getLanguageKey())), true);
						return 1;
					}));
	}

	private static LiteralArgumentBuilder<class_2168> createSetCommand(ConsumableChemicalHandler handler) {
		return method_9247("set")
				.then(method_9244("target", class_2186.method_9305())
				.then(method_9244("amount", FloatArgumentType.floatArg(0))
						.executes(ctx -> {
							class_3222 target = class_2186.method_9315(ctx, "target");
							float amount = FloatArgumentType.getFloat(ctx, "amount");
							handler.set(target, amount);
							ctx.getSource().method_9226(() ->
									class_2561.method_43469("command.chemical.set.response",
											class_2561.method_43471(handler.getLanguageKey()), amount, target.method_5477()), true);
							return 1;
						})));
	}

	private static LiteralArgumentBuilder<class_2168> createChangeCommand(ConsumableChemicalHandler handler) {
		return method_9247("change")
				.then(method_9244("target", class_2186.method_9305())
				.then(method_9244("amount", FloatArgumentType.floatArg())
						.executes(ctx -> {
							class_3222 target = class_2186.method_9315(ctx, "target");
							float amount = FloatArgumentType.getFloat(ctx, "amount");
							float after = handler.add(target, amount);
							ctx.getSource().method_9226(() ->
									class_2561.method_43469("command.chemical.change.response",
											handler.formatAmount(amount), handler.getLanguageKey(),
											target.method_5477(), handler.formatAmount(after)), true);
							return 1;
						})));
	}

}
