package ml.pluto7073.chemicals.handlers;

import ml.pluto7073.chemicals.Chemicals;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import java.util.Collection;
import java.util.List;

/**
 * The base class representing a Chemical
 * <p>
 * Two pre-made handlers already exist, {@link HalfLifeChemicalHandler} and {@link LinearChemicalHandler}
 * <p>
 * <code>HalfLifeChemicalHandler</code>
 * <p>
 * The most realistic of the two.  Exponentially ticks down the amount of the chemical in the player's body
 * based on the half life in ticks specified
 * <p>
 * <code>LinearChemicalHandler</code>
 * <p>
 * The simplest handler.  Removed a set amount of chemical from the player each tick, until the amount reaches 0
 */
public abstract class ConsumableChemicalHandler {

	public static final ConsumableChemicalHandler EMPTY =
			class_2378.method_10230(Chemicals.REGISTRY, Chemicals.id("empty"), new ConsumableChemicalHandler() {
				@Override
				public void tickPlayer(class_1657 player) {}

				@Override
				public Collection<class_1293> getEffectsForAmount(float amount, class_1937 level) {
					return List.of();
				}

				@Override
				public float get(class_1657 player) {
					return 0;
				}

				@Override
				public void add(class_1657 player, float amount) {}

				@Override
				public void set(class_1657 player, float amount) {}

				@Override
				public void defineDataForPlayer(class_2945 data) {}
			});

	protected final class_2940<Float> accessor;

	public ConsumableChemicalHandler() {
		accessor = class_2945.method_12791(class_1657.class, class_2943.field_13320);
	}

	/**
	 * Updates the current amount of the chemical in the specified player
	 * @param player The player to update
	 */
	public abstract void tickPlayer(class_1657 player);

	/**
	 * Gets the current amount of the chemical in the player
	 * @param player The player to retrieve
	 * @return Amount of the chemical
	 */
	public float get(class_1657 player) {
		return player.method_5841().method_12789(accessor);
	}

	/**
	 * Adds the chemical to a player
	 * @param player The player to add to
	 * @param amount The amount of the chemical to add
	 */
	public void add(class_1657 player, float amount) {
		float current = player.method_5841().method_12789(accessor);
		player.method_5841().method_12778(accessor, current + amount);
	}

	/**
	 * Sets amount of chemical in a player
	 * @param player The player to set
	 * @param amount Amount of chemical
	 */
	public void set(class_1657 player, float amount) {
		player.method_5841().method_12778(accessor, amount);
	}

	/**
	 * Get a list of effects associated with an amount of this chemical
	 * @param amount Amount of the chemical
	 * @param level The current Level, for utility purposes
	 * @return A list of <code>MobEffectInstance</code>s
	 */
	public abstract Collection<class_1293> getEffectsForAmount(float amount, class_1937 level);

	public void defineDataForPlayer(class_2945 data) {
		data.method_12784(accessor, 0f);
	}

	public void appendTooltip(List<class_2561> tooltip, float amount, class_1799 stack) {}

	public class_2960 getId() {
		return Chemicals.REGISTRY.method_29113(this).orElseThrow().method_29177();
	}

}
