package ml.pluto7073.chemicals.item;

import ml.pluto7073.chemicals.Chemicals;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * An abstract class for items that can contain a variable amount of any chemical
 * in a stack.  When an item that inherits <code>ChemicalContainingItem</code> is
 * finished using by a player and the <code>UseAnim</code> of the item is {@link class_1839#field_8946}
 * or {@link class_1839#field_8950}, any chemicals in the item will be added to the player
 * <p>
 * Note: This class is intended for items that have a variable amount of chemicals.
 * For Items that will always have the same amount of chemicals, use {@link class_4174.class_4175#addChemical(class_2960, float)}
 */
public abstract class ChemicalContainingItem extends class_1792 {

	protected ChemicalContainingItem(class_1793 settings) {
		super(settings);
	}

	/**
	 * Obtains the amount of a specific chemical stored in a stack
	 * @param id The ID representing the chemical
	 * @param stack The itemStack
	 * @return Amount of the desired chemical stored in the stack
	 */
	public abstract float getChemicalContent(class_2960 id, class_1799 stack);

	@Override
	public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {

		Chemicals.REGISTRY.forEach(handler -> {
			float amount = getChemicalContent(handler.getId(), stack);
			handler.appendTooltip(tooltip, amount, stack);
		});

	}
}
