package ml.pluto7073.chemicals.mixin;

import com.ibm.icu.impl.locale.XCldrStub;

import ml.pluto7073.chemicals.item.internal.ChemicalHolder;
import ml.pluto7073.chemicals.item.internal.ChemicalHolderBuilder;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.HashMap;
import java.util.Map;

@Mixin(class_4174.class)
public class FoodPropertiesMixin implements ChemicalHolder {

	@Unique private final Map<class_2960, Float> chemicals$Chemicals = new HashMap<>();

	@Override
	public void setChemicals(Map<class_2960, Float> chemicals) {
		chemicals$Chemicals.clear();
		chemicals$Chemicals.putAll(chemicals);
	}

	@Override
	public Map<class_2960, Float> getChemicals() {
		return XCldrStub.ImmutableMap.copyOf(chemicals$Chemicals);
	}

	@Mixin(class_4174.class_4175.class)
	public static class BuilderMixin implements ChemicalHolderBuilder {

		@Unique private final Map<class_2960, Float> chemicals$Chemicals = new HashMap<>();

		@Override
		public class_4174.class_4175 addChemical(class_2960 id, float amount) {
			chemicals$Chemicals.put(id, amount);
			return (class_4174.class_4175) (Object) this;
		}

		@Inject(at = @At("RETURN"), method = "build")
		private void chemicals$DispatchToProperties(CallbackInfoReturnable<class_4174> cir) {
			class_4174 food = cir.getReturnValue();
			food.setChemicals(chemicals$Chemicals);
		}

	}

}
