package ml.pluto7073.chemicals.mixin;

import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ConsumedInstance;
import ml.pluto7073.chemicals.handlers.ConsumedInstance.AbsorptionType;
import ml.pluto7073.chemicals.internal.ChemicalConsumer;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_4174;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Objects;

@Mixin(class_1657.class)
public abstract class PlayerMixin extends class_1309 implements ChemicalConsumer {

	protected PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
		super(entityType, level);
	}

	@Inject(at = @At("TAIL"), method = "defineSynchedData")
	private void chemicals$DefineChemicalTrackers(CallbackInfo ci) {
		Chemicals.CHEMICAL_HANDLER.forEach(handler -> handler.defineDataForPlayer(method_5841()));
	}

	@Inject(at = @At("HEAD"), method = "eat")
	private void chemicals$ConsumeFoodWithChemicals(class_1937 world, class_1799 stack, CallbackInfoReturnable<class_1799> cir) {
		if (world.field_9236) return;
		class_4174 food = stack.method_7909().method_19264();
		if (food == null) return;
		if (stack.method_7976() != class_1839.field_8950 && stack.method_7976() != class_1839.field_8946) return;
		AbsorptionType type = stack.method_7976() == class_1839.field_8950 ? AbsorptionType.EAT : AbsorptionType.DRINK;
		food.getChemicals().forEach((id, amount) -> {
			addChemical(Chemicals.CHEMICAL_HANDLER.method_10223(id), type, amount);
		});
	}

	@SuppressWarnings("AddedMixinMembersNamePattern")
	@Override
	public void addChemical(ConsumedInstance instance) {
		ChemicalConsumer.super.addChemical(instance);
	}

	@SuppressWarnings("AddedMixinMembersNamePattern")
	@Override
	public void clearChemicalInstances() {
		ChemicalConsumer.super.clearChemicalInstances();
	}
}
