package ml.pluto7073.chemicals.mixin;

import com.mojang.authlib.GameProfile;

import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ChemicalHandler;
import ml.pluto7073.chemicals.handlers.ConsumedInstance;
import ml.pluto7073.chemicals.internal.ChemicalConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;

@Mixin(class_3222.class)
public abstract class ServerPlayerMixin extends class_1657 implements ChemicalConsumer {

	@Unique private final List<ConsumedInstance> chemicals$consumedInstances = new ArrayList<>();

	public ServerPlayerMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
		super(world, pos, yaw, gameProfile);
	}

	@Inject(at = @At("TAIL"), method = "tick")
	private void chemicals$TickChemicalData(CallbackInfo ci) {
		Chemicals.CHEMICAL_HANDLER.forEach(handler -> handler.tickPlayer(this));
		List<ConsumedInstance> added = chemicals$consumedInstances.stream().filter(instance -> instance.update(this)).toList();
		chemicals$consumedInstances.removeAll(added);
	}

	@Inject(at = @At("TAIL"), method = "readAdditionalSaveData")
	private void chemicals$ReadChemicalData(class_2487 nbt, CallbackInfo ci) {
		clearChemicalInstances();
		if (!nbt.method_10545("Chemicals")) return;
		class_2487 data = nbt.method_10562("Chemicals");
		class_2487 extra = data.method_10545("ExtraData") ? data.method_10562("ExtraData") : new class_2487();
		for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
			handler.loadExtraPlayerData(this, extra);
			if (!data.method_10545(handler.getId().toString())) continue;
			float amount = data.method_10583(handler.getId().toString());
			handler.set(this, amount);
		}
		if (!data.method_10545("Consumed")) return;
		class_2499 consumed = data.method_10554("Consumed", class_2520.field_33260);
		for (class_2520 tag : consumed) {
			if (!(tag instanceof class_2487 inst)) continue;
			chemicals$consumedInstances.add(ConsumedInstance.load(inst));
		}
	}

	@Inject(at = @At("TAIL"), method = "addAdditionalSaveData")
	private void chemicals$SaveChemicalData(class_2487 nbt, CallbackInfo ci) {
		class_2487 tag = new class_2487();
		class_2487 extra = new class_2487();
		for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
			handler.saveExtraPlayerData(this, extra);
			float amount = handler.get(this);
			if (amount == 0) continue;
			tag.method_10548(handler.getId().toString(), amount);
		}
		tag.method_10566("ExtraData", extra);
		nbt.method_10566("Chemicals", tag);
		class_2499 consumed = new class_2499();
		for (ConsumedInstance instance : chemicals$consumedInstances) {
			consumed.add(instance.save());
		}
		nbt.method_10566("Consumed", consumed);
	}

	@Inject(at = @At("TAIL"), method = "tick")
	private void chemicals$ApplyChemicalEffects(CallbackInfo ci) {
		Chemicals.CHEMICAL_HANDLER.forEach(handler -> {
			float amount = handler.get(this);
			handler.getEffectsForAmount(amount, method_37908()).forEach(this::method_6092);
		});
	}

	@SuppressWarnings("AddedMixinMembersNamePattern")
	@Override
	public void addChemical(ConsumedInstance instance) {
		for (int i = 0; i < chemicals$consumedInstances.size(); i++) {
			ConsumedInstance existing = chemicals$consumedInstances.get(i);
			if (existing.matches(instance)) {
				chemicals$consumedInstances.set(i, existing.copyWithAmount(existing.remaining() + instance.remaining()));
				return;
			}
		}
		chemicals$consumedInstances.add(instance);
	}

	@SuppressWarnings("AddedMixinMembersNamePattern")
	@Override
	public void clearChemicalInstances() {
		chemicals$consumedInstances.clear();
		Chemicals.CHEMICAL_HANDLER.forEach(handler -> handler.set(this, 0));
	}
}
