/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.chemicals.handlers;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Collection;
import java.util.List;
import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ConsumedInstance;
import ml.pluto7073.chemicals.item.ChemicalContaining;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public abstract class ChemicalHandler {
    public static final ChemicalHandler EMPTY = (ChemicalHandler)class_2378.method_10230(Chemicals.CHEMICAL_HANDLER, (class_2960)Chemicals.id("air"), (Object)new ChemicalHandler(0.0f){

        @Override
        public void doTick(class_1657 player) {
        }

        @Override
        public Collection<class_1293> getEffectsForAmount(float amount, class_1937 level) {
            return List.of();
        }

        @Override
        public float add(class_1657 player, float amount) {
            return 0.0f;
        }
    });
    protected final class_2940<Float> accessor = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13320);
    protected final class_2940<Integer> ticksAccessor = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13327);
    protected final float maxRecommendedAmount;

    public ChemicalHandler(float maxRecommendedAmount) {
        this.maxRecommendedAmount = maxRecommendedAmount;
    }

    public final void tickPlayer(class_1657 player) {
        int ticks = (Integer)player.method_5841().method_12789(this.ticksAccessor) + 1;
        this.doTick(player);
        if (this.get(player) == 0.0f) {
            player.method_5841().method_12778(this.ticksAccessor, (Object)0);
            return;
        }
        player.method_5841().method_12778(this.ticksAccessor, (Object)ticks);
    }

    public int getTicksInPlayer(class_1657 player) {
        return (Integer)player.method_5841().method_12789(this.ticksAccessor);
    }

    protected abstract void doTick(class_1657 var1);

    public float get(class_1657 player) {
        return ((Float)player.method_5841().method_12789(this.accessor)).floatValue();
    }

    public float getStrength(class_1657 player) {
        return this.get(player) / this.maxRecommendedAmount;
    }

    public float add(class_1657 player, float amount) {
        float current = ((Float)player.method_5841().method_12789(this.accessor)).floatValue();
        if ((current += amount) < 0.0f) {
            current = 0.0f;
        }
        player.method_5841().method_12778(this.accessor, (Object)Float.valueOf(current));
        return current;
    }

    public void set(class_1657 player, float amount) {
        player.method_5841().method_12778(this.accessor, (Object)Float.valueOf(Math.max(0.0f, amount)));
    }

    public abstract Collection<class_1293> getEffectsForAmount(float var1, class_1937 var2);

    public void defineDataForPlayer(class_2945 data) {
        data.method_12784(this.accessor, (Object)Float.valueOf(0.0f));
        data.method_12784(this.ticksAccessor, (Object)0);
    }

    public void appendTooltip(List<class_2561> tooltip, float amount, class_1799 stack) {
        tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.chemicals.amount", (Object[])new Object[]{this.formatAmount(amount), class_2561.method_43471((String)this.getLanguageKey())}));
    }

    public class_2960 getId() {
        return ((class_5321)Chemicals.CHEMICAL_HANDLER.method_29113((Object)this).orElseThrow()).method_29177();
    }

    public String getLanguageKey() {
        return this.getId().method_42093("chemical_handler");
    }

    public String formatAmount(float amount) {
        return amount + "u";
    }

    public float getMaxRecommendedAmount() {
        return this.maxRecommendedAmount;
    }

    @Nullable
    public LiteralArgumentBuilder<class_2168> createCustomChemicalCommandExtension() {
        return null;
    }

    public void saveExtraPlayerData(class_1657 player, class_2487 tag) {
        int ticks = (Integer)player.method_5841().method_12789(this.ticksAccessor);
        if (ticks > 0) {
            tag.method_10569(this.getId().toString() + "/ticks", ticks);
        }
    }

    public void loadExtraPlayerData(class_1657 player, class_2487 tag) {
        if (tag.method_10545(this.getId().toString() + "/ticks")) {
            int ticks = tag.method_10550(this.getId().toString() + "/ticks");
            player.method_5841().method_12778(this.ticksAccessor, (Object)ticks);
        }
    }

    public ConsumedInstance createInstance(ConsumedInstance.AbsorptionType type, float amount) {
        return new ConsumedInstance(this, type, amount);
    }

    public ConsumedInstance createInstance(ConsumedInstance.AbsorptionType type, class_1799 stack, class_1937 level) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof ChemicalContaining)) {
            return new ConsumedInstance(this, type, 0.0f);
        }
        ChemicalContaining item = (ChemicalContaining)class_17922;
        return new ConsumedInstance(this, type, item.getChemicalContent(this.getId(), stack, level));
    }

    public void contrast(Vector4f rgba, class_1657 player) {
    }

    public void bloom(Vector4f rgba, class_1657 player) {
    }

    public static void init() {
    }
}

