/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.chemicals.handlers;

import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ChemicalHandler;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_6328;

@class_6328
public class ConsumedInstance {
    private final ChemicalHandler handler;
    private final AbsorptionType type;
    private final float totalAmount;
    private float remaining;

    ConsumedInstance(ChemicalHandler handler, AbsorptionType type, float totalAmount) {
        this.handler = handler;
        this.type = type;
        this.totalAmount = totalAmount;
        this.remaining = totalAmount;
    }

    public boolean matches(ConsumedInstance other) {
        return other.type == this.type && other.handler == this.handler;
    }

    public float remaining() {
        return this.remaining;
    }

    public boolean update(class_1657 player) {
        float absorbed = Math.min(this.type.getAbsorbedAmount(this.remaining), this.remaining);
        this.remaining -= absorbed;
        if ((double)Math.abs(this.remaining) < 1.0E-5 * (double)Math.abs(this.totalAmount)) {
            absorbed += this.remaining;
            this.remaining = 0.0f;
        }
        this.handler.add(player, absorbed);
        return this.remaining == 0.0f;
    }

    public ConsumedInstance copy() {
        return new ConsumedInstance(this.handler, this.type, this.totalAmount);
    }

    public ConsumedInstance copyWithAmount(float amount) {
        return new ConsumedInstance(this.handler, this.type, amount);
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        tag.method_10582("Chemical", Chemicals.CHEMICAL_HANDLER.method_10221((Object)this.handler).toString());
        tag.method_10582("Type", this.type.toString());
        tag.method_10548("Total", this.totalAmount);
        tag.method_10548("Remaining", this.remaining);
        return tag;
    }

    public static ConsumedInstance load(class_2487 tag) {
        ChemicalHandler handler = (ChemicalHandler)Chemicals.CHEMICAL_HANDLER.method_10223(new class_2960(tag.method_10558("Chemical")));
        AbsorptionType type = AbsorptionType.valueOf(tag.method_10558("Type"));
        float total = tag.method_10583("Total");
        float remaining = tag.method_10583("Remaining");
        ConsumedInstance instance = new ConsumedInstance(handler, type, total);
        instance.remaining = remaining;
        return instance;
    }

    public static enum AbsorptionType implements class_3542
    {
        INSTANT(0.0f),
        DRINK(0.98779464f),
        EAT(0.9926588f),
        SOLID_INHALE(0.58170915f),
        GAS_INHALE(0.89536434f);

        private final float rate;

        private AbsorptionType(float rate) {
            this.rate = rate;
        }

        float getAbsorbedAmount(float remaining) {
            return remaining * (1.0f - this.rate);
        }

        public String method_15434() {
            return this.name().toLowerCase();
        }
    }
}

