package ml.pluto7073.chemicals.mixin;

import com.mojang.authlib.GameProfile;

import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ConsumableChemicalHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3222.class)
public abstract class ServerPlayerMixin extends class_1657 {

	public ServerPlayerMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
		super(world, pos, yaw, gameProfile);
	}

	@Inject(at = @At("TAIL"), method = "tick")
	private void chemicals$TickChemicalData(CallbackInfo ci) {
		Chemicals.REGISTRY.forEach(handler -> handler.tickPlayer(this));
	}

	@Inject(at = @At("TAIL"), method = "readAdditionalSaveData")
	private void chemicals$ReadChemicalData(class_2487 nbt, CallbackInfo ci) {
		if (!nbt.method_10545("Chemicals")) return;
		class_2487 data = nbt.method_10562("Chemicals");
		class_2487 extra = data.method_10545("ExtraData") ? data.method_10562("ExtraData") : new class_2487();
		for (ConsumableChemicalHandler handler : Chemicals.REGISTRY) {
			handler.loadExtraPlayerData(this, extra);
			if (!data.method_10545(handler.getId().toString())) continue;
			float amount = data.method_10583(handler.getId().toString());
			handler.set(this, amount);
		}
	}

	@Inject(at = @At("TAIL"), method = "addAdditionalSaveData")
	private void chemicals$SaveChemicalData(class_2487 nbt, CallbackInfo ci) {
		class_2487 tag = new class_2487();
		class_2487 extra = new class_2487();
		for (ConsumableChemicalHandler handler : Chemicals.REGISTRY) {
			handler.saveExtraPlayerData(this, extra);
			float amount = handler.get(this);
			if (amount == 0) continue;
			tag.method_10548(handler.getId().toString(), amount);
		}
		tag.method_10566("ExtraData", extra);
		nbt.method_10566("Chemicals", tag);
	}

	@Inject(at = @At("TAIL"), method = "tick")
	private void chemicals$ApplyChemicalEffects(CallbackInfo ci) {
		Chemicals.REGISTRY.forEach(handler -> {
			float amount = handler.get(this);
			handler.getEffectsForAmount(amount, method_37908()).forEach(this::method_6092);
		});
	}

}
