package ml.pluto7073.chemicals.handlers;

import ml.pluto7073.chemicals.Chemicals;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_6328;

@class_6328
public class ConsumedInstance {

    private final ChemicalHandler handler;
    private final AbsorptionType type;
    private final float totalAmount;

    private float remaining;

    ConsumedInstance(ChemicalHandler handler, AbsorptionType type, float totalAmount) {
        this.handler = handler;
        this.type = type;
        this.totalAmount = totalAmount;
        remaining = totalAmount;
    }

    /**
     * Tests if another ConsumedInstance can be successfully merged with this one, meaning it is the same
     * chemical and type of consumption
     * @param other The other instance to compare
     * @return whether they can be merged or not
     */
    public boolean matches(ConsumedInstance other) {
        return other.type == type && other.handler == handler;
    }

    public float remaining() {
        return remaining;
    }

    @SuppressWarnings("deprecation")
    public boolean update(class_1657 player) {
        float absorbed = Math.min(type.getAbsorbedAmount(remaining), remaining);
        remaining -= absorbed;
        if (Math.abs(remaining) < 0.00001 * Math.abs(totalAmount)) {
            absorbed += remaining;
            remaining = 0;
        }
        handler.add(player, absorbed);
        return remaining == 0;
    }

    public ConsumedInstance copy() {
        return new ConsumedInstance(handler, type, totalAmount);
    }

    public ConsumedInstance copyWithAmount(float amount) {
        return new ConsumedInstance(handler, type, amount);
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        tag.method_10582("Chemical", Chemicals.CHEMICAL_HANDLER.method_10221(handler).toString());
        tag.method_10582("Type", type.toString());
        tag.method_10548("Total", totalAmount);
        tag.method_10548("Remaining", remaining);
        return tag;
    }

    public static ConsumedInstance load(class_2487 tag) {
        ChemicalHandler handler = Chemicals.CHEMICAL_HANDLER.method_10223(new class_2960(tag.method_10558("Chemical")));
        AbsorptionType type = AbsorptionType.valueOf(tag.method_10558("Type"));
        float total = tag.method_10583("Total");
        float remaining = tag.method_10583("Remaining");
        ConsumedInstance instance = new ConsumedInstance(handler, type, total);
        instance.remaining = remaining;
        return instance;
    }

    /**
     * Represents the type of chemical absorption that should be used when adding a chemical to a player.
     * The <code>rate</code> value represents the percentage delay in absorbing all the chemical.
     */
    public enum AbsorptionType implements class_3542 {

        INSTANT(0),
        DRINK(0.987794643221f),
        EAT(0.992658806871f),
        SOLID_INHALE(0.581709132937f),
        GAS_INHALE(0.895364369711f);

        private final float rate;

        AbsorptionType(float rate) {
            this.rate = rate;
        }

        float getAbsorbedAmount(float remaining) {
            return remaining * (1 - rate);
        }

        @Override
        public String method_15434() {
            return name().toLowerCase();
        }
    }

}
