package ml.pluto7073.chemicals.item;

import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_4174;

/**
 * An interface for items that can contain a variable amount of any chemical
 * in a stack.  When an item that inherits <code>ChemicalContaining</code> is
 * finished using by a player and the <code>UseAnim</code> of the item is {@link class_1839#field_8946}
 * or {@link class_1839#field_8950}, any chemicals in the item will be added to the player
 * <p>
 * Note: This interface is intended for items that have a variable amount of chemicals.
 * For Items that will always have the same amount of chemicals, use {@link class_4174.class_4175#addChemical(class_2960, float)}
 */
public interface ChemicalContaining {

    /**
     * Obtains the amount of a specific chemical stored in a stack
     * @param id The ID representing the chemical
     * @param stack The itemStack
     * @return Amount of the desired chemical stored in the stack
     */
    float getChemicalContent(class_2960 id, class_1799 stack, class_1937 level);

    /**
     * Gets the amount of a specific chemical to actually be consumed upon item use.  Use this if the item is consumed in portions.
     * @param id The ID representing the chemical
     * @param stack the item
     * @return Amount of the desired chemical that should be consumed.
     */
    default float getConsumedChemicalContent(class_2960 id, class_1799 stack, class_1937 level) {
        return getChemicalContent(id, stack, level);
    }

}
