package ml.pluto7073.chemicals.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ChemicalHandler;
import ml.pluto7073.chemicals.handlers.ConsumedInstance.AbsorptionType;
import ml.pluto7073.chemicals.item.ChemicalContaining;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_4174;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;

@Mixin(class_1799.class)
public abstract class ItemStackMixin {

    @Shadow public abstract class_1792 getItem();

    @Unique private class_1799 chem$This() {
        return (class_1799) (Object) this;
    }

    @Inject(
            method = "getTooltipLines",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/Item;appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V"
            )
    )
    private void chemicals$AddChemicalTooltipForFood(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, @Local List<class_2561> list) {
        if (!getItem().method_19263() || getItem().method_19264() == null) return;
        if (!(context.method_47370() || context.method_8035())) return;

        class_4174 properties = getItem().method_19264();
        for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
            if (!properties.getChemicals().containsKey(handler.getId())) continue;
            float amount = properties.getChemicals().get(handler.getId());
            if (Math.abs(amount) < 0.0001f) continue;
            handler.appendTooltip(list, amount, chem$This());
        }
    }

    @Inject(
            method = "getTooltipLines",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/Item;appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V"
            )
    )
    private void chemicals$AddChemicalTooltipForChemicalContaining(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, @Local List<class_2561> list) {
        if (!(getItem() instanceof ChemicalContaining item)) return;
        if (!(context.method_47370() || context.method_8035())) return;
        for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
            float amount = item.getChemicalContent(handler.getId(), chem$This(), player.method_37908());
            if (Math.abs(amount) < 0.0001f) return;
            handler.appendTooltip(list, amount, chem$This());
        }
    }

    @Inject(at = @At("HEAD"), method = "finishUsingItem")
    private void chemicals$AddChemicalsToPlayer(class_1937 world, class_1309 user, CallbackInfoReturnable<class_1799> cir) {
        if (!(user instanceof class_1657 player) || world.field_9236 || !(getItem() instanceof ChemicalContaining)) return;
        class_1839 anim = getItem().method_7853(chem$This());
        if (!anim.equals(class_1839.field_8946) && !anim.equals(class_1839.field_8950)) return;
        AbsorptionType type = anim == class_1839.field_8946 ? AbsorptionType.DRINK : AbsorptionType.EAT;
        for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
            player.addChemical(handler.createInstance(type, chem$This(), world));
        }
    }

}
