/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.chemicals.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ChemicalHandler;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ChemicalCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection selection) {
        LiteralArgumentBuilder chemicals = Commands.literal((String)"chemicals");
        for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
            if (handler.getId().getPath().equals("air")) continue;
            LiteralArgumentBuilder<CommandSourceStack> custom = handler.createCustomChemicalCommandExtension();
            chemicals.then(custom != null ? custom : ChemicalCommands.createChemicalCommand(handler));
        }
        dispatcher.register(chemicals);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createChemicalCommand(ChemicalHandler handler) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)handler.getId().toString()).then(ChemicalCommands.createGetCommand(handler))).then(ChemicalCommands.createSetCommand(handler))).then(ChemicalCommands.createChangeCommand(handler));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createGetCommand(ChemicalHandler handler) {
        return (LiteralArgumentBuilder)Commands.literal((String)"get").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"target");
            String amount = handler.formatAmount(handler.get((Player)target));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.chemical.get.response", (Object[])new Object[]{target.getName(), amount, Component.translatable((String)handler.getLanguageKey())}), true);
            return (int)handler.get((Player)target);
        }));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createSetCommand(ChemicalHandler handler) {
        return (LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(ctx -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"target");
            float amount = FloatArgumentType.getFloat((CommandContext)ctx, (String)"amount");
            handler.set((Player)target, amount);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.chemical.set.response", (Object[])new Object[]{Component.translatable((String)handler.getLanguageKey()), Float.valueOf(amount), target.getName()}), true);
            return 1;
        })));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createChangeCommand(ChemicalHandler handler) {
        return (LiteralArgumentBuilder)Commands.literal((String)"change").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"target");
            float amount = FloatArgumentType.getFloat((CommandContext)ctx, (String)"amount");
            float after = handler.add((Player)target, amount);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.chemical.change.response", (Object[])new Object[]{handler.formatAmount(amount), handler.getLanguageKey(), target.getName(), handler.formatAmount(after)}), true);
            return 1;
        })));
    }
}

