/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.chemicals.handlers;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Collection;
import java.util.List;
import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ConsumedInstance;
import ml.pluto7073.chemicals.item.ChemicalContaining;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public abstract class ChemicalHandler {
    public static final ChemicalHandler EMPTY = (ChemicalHandler)Registry.register(Chemicals.CHEMICAL_HANDLER, (ResourceLocation)Chemicals.id("empty"), (Object)new ChemicalHandler(0.0f){

        @Override
        public void doTick(Player player) {
        }

        @Override
        public Collection<MobEffectInstance> getEffectsForAmount(float amount, Level level) {
            return List.of();
        }

        @Override
        public float add(Player player, float amount) {
            return 0.0f;
        }
    });
    protected final EntityDataAccessor<Float> accessor = SynchedEntityData.defineId(Player.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected final EntityDataAccessor<Integer> ticksAccessor = SynchedEntityData.defineId(Player.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected final float maxRecommendedAmount;

    public ChemicalHandler(float maxRecommendedAmount) {
        this.maxRecommendedAmount = maxRecommendedAmount;
    }

    public final void tickPlayer(Player player) {
        int ticks = (Integer)player.getEntityData().get(this.ticksAccessor) + 1;
        this.doTick(player);
        if (this.get(player) == 0.0f) {
            player.getEntityData().set(this.ticksAccessor, (Object)0);
            return;
        }
        player.getEntityData().set(this.ticksAccessor, (Object)ticks);
    }

    public abstract void doTick(Player var1);

    public float get(Player player) {
        return ((Float)player.getEntityData().get(this.accessor)).floatValue();
    }

    public float getStrength(Player player) {
        return this.get(player) / this.getMaxRecommendedAmount();
    }

    public float add(Player player, float amount) {
        float current = ((Float)player.getEntityData().get(this.accessor)).floatValue();
        if ((current += amount) < 0.0f) {
            current = 0.0f;
        }
        player.getEntityData().set(this.accessor, (Object)Float.valueOf(current));
        return current;
    }

    public void set(Player player, float amount) {
        player.getEntityData().set(this.accessor, (Object)Float.valueOf(Math.max(0.0f, amount)));
    }

    public abstract Collection<MobEffectInstance> getEffectsForAmount(float var1, Level var2);

    public void defineDataForPlayer(SynchedEntityData data) {
        data.define(this.accessor, (Object)Float.valueOf(0.0f));
        data.define(this.ticksAccessor, (Object)0);
    }

    public void appendTooltip(List<Component> tooltip, float amount, ItemStack stack) {
        tooltip.add((Component)Component.translatable((String)"tooltip.chemicals.amount", (Object[])new Object[]{this.formatAmount(amount), Component.translatable((String)this.getLanguageKey())}));
    }

    public ResourceLocation getId() {
        return ((ResourceKey)Chemicals.CHEMICAL_HANDLER.getResourceKey((Object)this).orElseThrow()).location();
    }

    public String getLanguageKey() {
        return this.getId().toLanguageKey("chemical_handler");
    }

    public String formatAmount(float amount) {
        return amount + "u";
    }

    public float getMaxRecommendedAmount() {
        return this.maxRecommendedAmount;
    }

    @Nullable
    public LiteralArgumentBuilder<CommandSourceStack> createCustomChemicalCommandExtension() {
        return null;
    }

    public void saveExtraPlayerData(Player player, CompoundTag tag) {
        int ticks = (Integer)player.getEntityData().get(this.ticksAccessor);
        if (ticks > 0) {
            tag.putInt(this.getId().toString() + "/ticks", ticks);
        }
    }

    public void loadExtraPlayerData(Player player, CompoundTag tag) {
        if (tag.contains(this.getId().toString() + "/ticks")) {
            int ticks = tag.getInt(this.getId().toString() + "/ticks");
            player.getEntityData().set(this.ticksAccessor, (Object)ticks);
        }
    }

    public ConsumedInstance createInstance(ConsumedInstance.AbsorptionType type, float amount) {
        return new ConsumedInstance(this, type, amount);
    }

    public ConsumedInstance createInstance(ConsumedInstance.AbsorptionType type, ItemStack stack, Level level) {
        Item item = stack.getItem();
        if (!(item instanceof ChemicalContaining)) {
            return new ConsumedInstance(this, type, 0.0f);
        }
        ChemicalContaining item2 = (ChemicalContaining)item;
        return new ConsumedInstance(this, type, item2.getConsumedChemicalContent(this.getId(), stack, level));
    }

    public void contrast(Vector4f rgba, Player player) {
    }

    public void bloom(Vector4f rgba, Player player) {
    }

    public static void init() {
    }
}

