/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.chemicals.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ChemicalHandler;
import ml.pluto7073.chemicals.handlers.ConsumedInstance;
import ml.pluto7073.chemicals.item.ChemicalContaining;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    public abstract Item method_7909();

    @Unique
    private ItemStack chem$This() {
        return (ItemStack)this;
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V")})
    private void chemicals$AddChemicalTooltipForFood(Player player, TooltipFlag context, CallbackInfoReturnable<List<Component>> cir, @Local List<Component> list) {
        if (!this.method_7909().isEdible() || this.method_7909().getFoodProperties() == null) {
            return;
        }
        if (!context.isCreative() && !context.isAdvanced()) {
            return;
        }
        FoodProperties properties = this.method_7909().getFoodProperties();
        for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
            float amount;
            if (!properties.getChemicals().containsKey(handler.getId()) || Math.abs(amount = ((Float)properties.getChemicals().get(handler.getId())).floatValue()) < 1.0E-4f) continue;
            handler.appendTooltip(list, amount, this.chem$This());
        }
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V")})
    private void chemicals$AddChemicalTooltipForChemicalContaining(Player player, TooltipFlag context, CallbackInfoReturnable<List<Component>> cir, @Local List<Component> list) {
        Item item = this.method_7909();
        if (!(item instanceof ChemicalContaining)) {
            return;
        }
        ChemicalContaining item2 = (ChemicalContaining)item;
        if (!context.isCreative() && !context.isAdvanced()) {
            return;
        }
        for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
            float amount = item2.getChemicalContent(handler.getId(), this.chem$This(), player.level());
            if (Math.abs(amount) < 1.0E-4f) {
                return;
            }
            handler.appendTooltip(list, amount, this.chem$This());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"finishUsingItem"})
    private void chemicals$AddChemicalsToPlayer(Level world, LivingEntity user, CallbackInfoReturnable<ItemStack> cir) {
        Player player;
        block6: {
            block5: {
                if (!(user instanceof Player)) break block5;
                player = (Player)user;
                if (!world.isClientSide && this.method_7909() instanceof ChemicalContaining) break block6;
            }
            return;
        }
        UseAnim anim = this.method_7909().getUseAnimation(this.chem$This());
        if (!anim.equals((Object)UseAnim.DRINK) && !anim.equals((Object)UseAnim.EAT)) {
            return;
        }
        ConsumedInstance.AbsorptionType type = anim == UseAnim.DRINK ? ConsumedInstance.AbsorptionType.DRINK : ConsumedInstance.AbsorptionType.EAT;
        for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
            player.addChemical(handler.createInstance(type, this.chem$This(), world));
        }
    }
}

