/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.chemicals.mixin;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ChemicalHandler;
import ml.pluto7073.chemicals.handlers.ConsumedInstance;
import ml.pluto7073.chemicals.internal.ChemicalConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMixin
extends class_1657
implements ChemicalConsumer {
    @Unique
    private final List<ConsumedInstance> chemicals$consumedInstances = new ArrayList<ConsumedInstance>();

    public ServerPlayerMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void chemicals$TickChemicalData(CallbackInfo ci) {
        Chemicals.CHEMICAL_HANDLER.forEach(handler -> handler.tickPlayer(this));
        List<ConsumedInstance> added = this.chemicals$consumedInstances.stream().filter(instance -> instance.update(this)).toList();
        this.chemicals$consumedInstances.removeAll(added);
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void chemicals$ReadChemicalData(class_2487 nbt, CallbackInfo ci) {
        this.clearChemicalInstances();
        if (!nbt.method_10545("Chemicals")) {
            return;
        }
        class_2487 data = nbt.method_10562("Chemicals");
        class_2487 extra = data.method_10545("ExtraData") ? data.method_10562("ExtraData") : new class_2487();
        for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
            handler.loadExtraPlayerData(this, extra);
            if (!data.method_10545(handler.getId().toString())) continue;
            float amount = data.method_10583(handler.getId().toString());
            handler.set(this, amount);
        }
        if (!data.method_10545("Consumed")) {
            return;
        }
        class_2499 consumed = data.method_10554("Consumed", 10);
        for (class_2520 tag : consumed) {
            if (!(tag instanceof class_2487)) continue;
            class_2487 inst = (class_2487)tag;
            this.chemicals$consumedInstances.add(ConsumedInstance.load(inst));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void chemicals$SaveChemicalData(class_2487 nbt, CallbackInfo ci) {
        class_2487 tag = new class_2487();
        class_2487 extra = new class_2487();
        for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
            handler.saveExtraPlayerData(this, extra);
            float amount = handler.get(this);
            if ((double)Math.abs(amount) < 1.0E-5) continue;
            tag.method_10548(handler.getId().toString(), amount);
        }
        tag.method_10566("ExtraData", (class_2520)extra);
        nbt.method_10566("Chemicals", (class_2520)tag);
        class_2499 consumed = new class_2499();
        for (ConsumedInstance instance : this.chemicals$consumedInstances) {
            consumed.add((Object)instance.save());
        }
        nbt.method_10566("Consumed", (class_2520)consumed);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void chemicals$ApplyChemicalEffects(CallbackInfo ci) {
        for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
            float amount = handler.get(this);
            handler.getEffectsForAmount(amount, this.method_37908()).forEach(arg_0 -> ((ServerPlayerMixin)this).method_6092(arg_0));
        }
    }

    @Override
    public void addChemical(ConsumedInstance instance) {
        for (int i = 0; i < this.chemicals$consumedInstances.size(); ++i) {
            ConsumedInstance existing = this.chemicals$consumedInstances.get(i);
            if (!existing.matches(instance)) continue;
            this.chemicals$consumedInstances.set(i, existing.copyWithAmount(existing.remaining() + instance.remaining()));
            return;
        }
    }

    @Override
    public void clearChemicalInstances() {
        this.chemicals$consumedInstances.clear();
        Chemicals.CHEMICAL_HANDLER.forEach(handler -> handler.set(this, 0.0f));
    }
}

