/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.chemicals.mixin;

import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ChemicalHandler;
import ml.pluto7073.chemicals.handlers.ConsumedInstance;
import ml.pluto7073.chemicals.internal.ChemicalConsumer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements ChemicalConsumer {
    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"})
    private void chemicals$DefineChemicalTrackers(CallbackInfo ci) {
        Chemicals.CHEMICAL_HANDLER.forEach(handler -> handler.defineDataForPlayer(this.getEntityData()));
    }

    @Inject(at={@At(value="HEAD")}, method={"eat"})
    private void chemicals$ConsumeFoodWithChemicals(Level world, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        if (world.isClientSide) {
            return;
        }
        FoodProperties food = stack.getItem().getFoodProperties();
        if (food == null) {
            return;
        }
        if (stack.getUseAnimation() != UseAnim.EAT && stack.getUseAnimation() != UseAnim.DRINK) {
            return;
        }
        ConsumedInstance.AbsorptionType type = stack.getUseAnimation() == UseAnim.EAT ? ConsumedInstance.AbsorptionType.EAT : ConsumedInstance.AbsorptionType.DRINK;
        food.getChemicals().forEach((id, amount) -> this.addChemical((ChemicalHandler)Chemicals.CHEMICAL_HANDLER.get(id), type, amount.floatValue()));
    }
}

