/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.chemicals.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ChemicalHandler;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ChemicalCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection selection) {
        LiteralArgumentBuilder chemicals = Commands.m_82127_((String)"chemicals");
        for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
            if (handler.getId().m_135815_().equals("air")) continue;
            LiteralArgumentBuilder<CommandSourceStack> custom = handler.createCustomChemicalCommandExtension();
            chemicals.then(custom != null ? custom : ChemicalCommands.createChemicalCommand(handler));
        }
        dispatcher.register(chemicals);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createChemicalCommand(ChemicalHandler handler) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)handler.getId().toString()).then(ChemicalCommands.createGetCommand(handler))).then(ChemicalCommands.createSetCommand(handler))).then(ChemicalCommands.createChangeCommand(handler));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createGetCommand(ChemicalHandler handler) {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"target");
            String amount = handler.formatAmount(handler.get((Player)target));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.chemical.get.response", (Object[])new Object[]{target.m_7755_(), amount, Component.m_237115_((String)handler.getLanguageKey())}), true);
            return (int)handler.get((Player)target);
        }));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createSetCommand(ChemicalHandler handler) {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(ctx -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"target");
            float amount = FloatArgumentType.getFloat((CommandContext)ctx, (String)"amount");
            handler.set((Player)target, amount);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.chemical.set.response", (Object[])new Object[]{Component.m_237115_((String)handler.getLanguageKey()), Float.valueOf(amount), target.m_7755_()}), true);
            return 1;
        })));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createChangeCommand(ChemicalHandler handler) {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"change").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"target");
            float amount = FloatArgumentType.getFloat((CommandContext)ctx, (String)"amount");
            float after = handler.add((Player)target, amount);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.chemical.change.response", (Object[])new Object[]{handler.formatAmount(amount), handler.getLanguageKey(), target.m_7755_(), handler.formatAmount(after)}), true);
            return 1;
        })));
    }
}

