/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.chemicals.handlers;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Collection;
import java.util.List;
import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ConsumedInstance;
import ml.pluto7073.chemicals.item.ChemicalContaining;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public abstract class ChemicalHandler {
    public static final ChemicalHandler EMPTY = (ChemicalHandler)Registry.m_122965_(Chemicals.CHEMICAL_HANDLER, (ResourceLocation)Chemicals.id("empty"), (Object)new ChemicalHandler(0.0f){

        @Override
        public void doTick(Player player) {
        }

        @Override
        public Collection<MobEffectInstance> getEffectsForAmount(float amount, Level level) {
            return List.of();
        }

        @Override
        public float add(Player player, float amount) {
            return 0.0f;
        }
    });
    protected final EntityDataAccessor<Float> accessor = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected final EntityDataAccessor<Integer> ticksAccessor = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected final float maxRecommendedAmount;

    public ChemicalHandler(float maxRecommendedAmount) {
        this.maxRecommendedAmount = maxRecommendedAmount;
    }

    public final void tickPlayer(Player player) {
        int ticks = (Integer)player.m_20088_().m_135370_(this.ticksAccessor) + 1;
        this.doTick(player);
        if (this.get(player) == 0.0f) {
            player.m_20088_().m_135381_(this.ticksAccessor, (Object)0);
            return;
        }
        player.m_20088_().m_135381_(this.ticksAccessor, (Object)ticks);
    }

    public abstract void doTick(Player var1);

    public float get(Player player) {
        return ((Float)player.m_20088_().m_135370_(this.accessor)).floatValue();
    }

    public float getStrength(Player player) {
        return this.get(player) / this.getMaxRecommendedAmount();
    }

    public float add(Player player, float amount) {
        float current = ((Float)player.m_20088_().m_135370_(this.accessor)).floatValue();
        if ((current += amount) < 0.0f) {
            current = 0.0f;
        }
        player.m_20088_().m_135381_(this.accessor, (Object)Float.valueOf(current));
        return current;
    }

    public void set(Player player, float amount) {
        player.m_20088_().m_135381_(this.accessor, (Object)Float.valueOf(Math.max(0.0f, amount)));
    }

    public abstract Collection<MobEffectInstance> getEffectsForAmount(float var1, Level var2);

    public void defineDataForPlayer(SynchedEntityData data) {
        data.m_135372_(this.accessor, (Object)Float.valueOf(0.0f));
        data.m_135372_(this.ticksAccessor, (Object)0);
    }

    public void appendTooltip(List<Component> tooltip, float amount, ItemStack stack) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.chemicals.amount", (Object[])new Object[]{this.formatAmount(amount), Component.m_237115_((String)this.getLanguageKey())}));
    }

    public ResourceLocation getId() {
        return ((ResourceKey)Chemicals.CHEMICAL_HANDLER.m_7854_((Object)this).orElseThrow()).m_135782_();
    }

    public String getLanguageKey() {
        return this.getId().m_214296_("chemical_handler");
    }

    public String formatAmount(float amount) {
        return amount + "u";
    }

    public float getMaxRecommendedAmount() {
        return this.maxRecommendedAmount;
    }

    @Nullable
    public LiteralArgumentBuilder<CommandSourceStack> createCustomChemicalCommandExtension() {
        return null;
    }

    public void saveExtraPlayerData(Player player, CompoundTag tag) {
        int ticks = (Integer)player.m_20088_().m_135370_(this.ticksAccessor);
        if (ticks > 0) {
            tag.m_128405_(this.getId().toString() + "/ticks", ticks);
        }
    }

    public void loadExtraPlayerData(Player player, CompoundTag tag) {
        if (tag.m_128441_(this.getId().toString() + "/ticks")) {
            int ticks = tag.m_128451_(this.getId().toString() + "/ticks");
            player.m_20088_().m_135381_(this.ticksAccessor, (Object)ticks);
        }
    }

    public ConsumedInstance createInstance(ConsumedInstance.AbsorptionType type, float amount) {
        return new ConsumedInstance(this, type, amount);
    }

    public ConsumedInstance createInstance(ConsumedInstance.AbsorptionType type, ItemStack stack, Level level) {
        Item item = stack.m_41720_();
        if (!(item instanceof ChemicalContaining)) {
            return new ConsumedInstance(this, type, 0.0f);
        }
        ChemicalContaining item2 = (ChemicalContaining)item;
        return new ConsumedInstance(this, type, item2.getConsumedChemicalContent(this.getId(), stack, level));
    }

    public void contrast(Vector4f rgba, Player player) {
    }

    public void bloom(Vector4f rgba, Player player) {
    }

    public static void init() {
    }
}

