/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.chemicals.handlers;

import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ChemicalHandler;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
public class ConsumedInstance {
    private final ChemicalHandler handler;
    private final AbsorptionType type;
    private final float totalAmount;
    private float remaining;

    ConsumedInstance(ChemicalHandler handler, AbsorptionType type, float totalAmount) {
        this.handler = handler;
        this.type = type;
        this.totalAmount = totalAmount;
        this.remaining = totalAmount;
    }

    public boolean matches(ConsumedInstance other) {
        return other.type == this.type && other.handler == this.handler;
    }

    public float remaining() {
        return this.remaining;
    }

    public boolean update(Player player) {
        float absorbed = Math.min(this.type.getAbsorbedAmount(this.remaining), this.remaining);
        this.remaining -= absorbed;
        if ((double)Math.abs(this.remaining) < 1.0E-5 * (double)Math.abs(this.totalAmount)) {
            absorbed += this.remaining;
            this.remaining = 0.0f;
        }
        this.handler.add(player, absorbed);
        return this.remaining == 0.0f;
    }

    public ConsumedInstance copy() {
        return new ConsumedInstance(this.handler, this.type, this.totalAmount);
    }

    public ConsumedInstance copyWithAmount(float amount) {
        return new ConsumedInstance(this.handler, this.type, amount);
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Chemical", Chemicals.CHEMICAL_HANDLER.m_7981_((Object)this.handler).toString());
        tag.m_128359_("Type", this.type.toString());
        tag.m_128350_("Total", this.totalAmount);
        tag.m_128350_("Remaining", this.remaining);
        return tag;
    }

    public static ConsumedInstance load(CompoundTag tag) {
        ChemicalHandler handler = (ChemicalHandler)Chemicals.CHEMICAL_HANDLER.m_7745_(new ResourceLocation(tag.m_128461_("Chemical")));
        AbsorptionType type = AbsorptionType.valueOf(tag.m_128461_("Type"));
        float total = tag.m_128457_("Total");
        float remaining = tag.m_128457_("Remaining");
        ConsumedInstance instance = new ConsumedInstance(handler, type, total);
        instance.remaining = remaining;
        return instance;
    }

    public static enum AbsorptionType implements StringRepresentable
    {
        INSTANT(0.0f),
        DRINK(0.98779464f),
        EAT(0.9926588f),
        SOLID_INHALE(0.58170915f),
        GAS_INHALE(0.89536434f);

        private final float rate;

        private AbsorptionType(float rate) {
            this.rate = rate;
        }

        float getAbsorbedAmount(float remaining) {
            return remaining * (1.0f - this.rate);
        }

        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

