/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.chemicals.mixin;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import ml.pluto7073.chemicals.internal.ChemicalHolder;
import ml.pluto7073.chemicals.internal.ChemicalHolderBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FoodProperties.class})
public class FoodPropertiesMixin
implements ChemicalHolder {
    @Unique
    private final Map<ResourceLocation, Float> chemicals$Chemicals = new HashMap<ResourceLocation, Float>();

    @Override
    public void setChemicals(Map<ResourceLocation, Float> chemicals) {
        this.chemicals$Chemicals.clear();
        this.chemicals$Chemicals.putAll(chemicals);
    }

    @Override
    public Map<ResourceLocation, Float> getChemicals() {
        return ImmutableMap.copyOf(this.chemicals$Chemicals);
    }

    @Mixin(value={FoodProperties.Builder.class})
    public static class BuilderMixin
    implements ChemicalHolderBuilder {
        @Unique
        private final Map<ResourceLocation, Float> chemicals$Chemicals = new HashMap<ResourceLocation, Float>();

        @Override
        public FoodProperties.Builder addChemical(ResourceLocation id, float amount) {
            this.chemicals$Chemicals.put(id, Float.valueOf(amount));
            return (FoodProperties.Builder)this;
        }

        @Inject(at={@At(value="RETURN")}, method={"build"})
        private void chemicals$DispatchToProperties(CallbackInfoReturnable<FoodProperties> cir) {
            FoodProperties food = (FoodProperties)cir.getReturnValue();
            food.setChemicals(this.chemicals$Chemicals);
        }
    }
}

