/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.chemicals.mixin;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.ChemicalHandler;
import ml.pluto7073.chemicals.handlers.ConsumedInstance;
import ml.pluto7073.chemicals.internal.ChemicalConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player
implements ChemicalConsumer {
    @Unique
    private final List<ConsumedInstance> chemicals$consumedInstances = new ArrayList<ConsumedInstance>();

    public ServerPlayerMixin(Level world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void chemicals$TickChemicalData(CallbackInfo ci) {
        Chemicals.CHEMICAL_HANDLER.forEach(handler -> handler.tickPlayer(this));
        List<ConsumedInstance> added = this.chemicals$consumedInstances.stream().filter(instance -> instance.update(this)).toList();
        this.chemicals$consumedInstances.removeAll(added);
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void chemicals$ReadChemicalData(CompoundTag nbt, CallbackInfo ci) {
        this.clearChemicalInstances();
        if (!nbt.m_128441_("Chemicals")) {
            return;
        }
        CompoundTag data = nbt.m_128469_("Chemicals");
        CompoundTag extra = data.m_128441_("ExtraData") ? data.m_128469_("ExtraData") : new CompoundTag();
        for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
            handler.loadExtraPlayerData(this, extra);
            if (!data.m_128441_(handler.getId().toString())) continue;
            float amount = data.m_128457_(handler.getId().toString());
            handler.set(this, amount);
        }
        if (!data.m_128441_("Consumed")) {
            return;
        }
        ListTag consumed = data.m_128437_("Consumed", 10);
        for (Tag tag : consumed) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag inst = (CompoundTag)tag;
            this.chemicals$consumedInstances.add(ConsumedInstance.load(inst));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void chemicals$SaveChemicalData(CompoundTag nbt, CallbackInfo ci) {
        CompoundTag tag = new CompoundTag();
        CompoundTag extra = new CompoundTag();
        for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
            handler.saveExtraPlayerData(this, extra);
            float amount = handler.get(this);
            if ((double)Math.abs(amount) < 1.0E-5) continue;
            tag.m_128350_(handler.getId().toString(), amount);
        }
        tag.m_128365_("ExtraData", (Tag)extra);
        nbt.m_128365_("Chemicals", (Tag)tag);
        ListTag consumed = new ListTag();
        for (ConsumedInstance instance : this.chemicals$consumedInstances) {
            consumed.add((Object)instance.save());
        }
        nbt.m_128365_("Consumed", (Tag)consumed);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void chemicals$ApplyChemicalEffects(CallbackInfo ci) {
        for (ChemicalHandler handler : Chemicals.CHEMICAL_HANDLER) {
            float amount = handler.get(this);
            handler.getEffectsForAmount(amount, this.m_9236_()).forEach(arg_0 -> ((ServerPlayerMixin)this).m_7292_(arg_0));
        }
    }

    @Override
    public void addChemical(ConsumedInstance instance) {
        for (int i = 0; i < this.chemicals$consumedInstances.size(); ++i) {
            ConsumedInstance existing = this.chemicals$consumedInstances.get(i);
            if (!existing.matches(instance)) continue;
            this.chemicals$consumedInstances.set(i, existing.copyWithAmount(existing.remaining() + instance.remaining()));
            return;
        }
    }

    @Override
    public void clearChemicalInstances() {
        this.chemicals$consumedInstances.clear();
        Chemicals.CHEMICAL_HANDLER.forEach(handler -> handler.set(this, 0.0f));
    }
}

