package ml.pluto7073.pdapi.addition;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public class DrinkAddition {

    private final OnDrink[] actions;
    private final boolean changesColor;
    private final int color;
    private final int caffeine;
    private final int maxAmount;
    private final JsonObject originalData;

    public DrinkAddition(OnDrink[] actions, boolean changesColor, int color, int caffeine, int maxAmount, JsonObject originalData) {
        this.actions = actions;
        this.changesColor = changesColor;
        this.color = color;
        this.caffeine = caffeine;
        this.maxAmount = maxAmount;
        this.originalData = originalData;
    }

    public void onDrink(class_1799 stack, class_1937 world, class_1309 user) {
        for (OnDrink action : actions) {
            action.onDrink(stack, world, user);
        }
    }

    public boolean changesColor() {
        return changesColor;
    }

    public int getColor() {
        return color;
    }

    public int getCaffeine() {
        return caffeine;
    }

    public int getMaxAmount() {
        return maxAmount;
    }

    public JsonObject asJsonObject() {
        return originalData;
    }

    public String getTranslationKey() {
        class_2960 id = DrinkAdditions.getId(this);
        return "drink_addition." + id.method_12836() + "." + id.method_12832();
    }

    public static class Builder {

        private final List<OnDrink> actions;
        private boolean changesColor;
        private int color;
        private int caffeine;
        private int maxAmount;

        public Builder() {
            actions = new ArrayList<>();
            changesColor = false;
            color = 0;
            caffeine = 0;
            maxAmount = 0;
        }

        public Builder addAction(OnDrink action) {
            actions.add(action);
            return this;
        }

        public Builder changesColor(boolean changesColor) {
            this.changesColor = changesColor;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        public Builder caffeine(int caffeine) {
            this.caffeine = caffeine;
            return this;
        }

        public Builder maxAmount(int amount) {
            this.maxAmount = amount;
            return this;
        }

        public DrinkAddition build(JsonObject data) {
            return new DrinkAddition(actions.toArray(new OnDrink[0]), changesColor, color, caffeine, maxAmount, data);
        }

    }

}
