package ml.pluto7073.pdapi.addition;

import com.google.gson.JsonObject;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.networking.packet.s2c.SyncAdditionRegistryS2CPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import java.util.HashMap;
import java.util.Map;

public class DrinkAdditions {

    private static final Map<class_2960, DrinkAddition> REGISTRY = new HashMap<>();
    public static final String ADDITIONS_NBT_KEY = "Additions";

    public static final DrinkAddition EMPTY = register(PDAPI.asId("empty"), new DrinkAddition(new OnDrink[0], false, 0, 0, 0, new JsonObject()));

    public static DrinkAddition register(class_2960 id, DrinkAddition addition) {
        REGISTRY.put(id, addition);
        return addition;
    }

    public static class_2960 getId(DrinkAddition addition) {
        for (Map.Entry<class_2960, DrinkAddition> entry : REGISTRY.entrySet()) {
            if (addition.equals(entry.getValue())) {
                return entry.getKey();
            }
        }
        return null;
    }

    public static DrinkAddition get(class_2960 id) {
        return REGISTRY.get(id);
    }

    public static void resetRegistry() {
        REGISTRY.clear();
        REGISTRY.put(PDAPI.asId("empty"), EMPTY);
    }

    public static boolean containsId(class_2960 id) {
        return REGISTRY.containsKey(id);
    }

    public static boolean containsAddition(DrinkAddition addition) {
        return REGISTRY.containsValue(addition);
    }

    public static boolean contains(class_2960 id, DrinkAddition addition) {
        return containsId(id) && containsAddition(addition) && get(id).equals(addition);
    }

    public static boolean contains(Map.Entry<class_2960, DrinkAddition> entry) {
        return contains(entry.getKey(), entry.getValue());
    }

    public static void send(class_3222 entity) {

        Map<class_2960, JsonObject> additions = new HashMap<>();
        REGISTRY.forEach((id, add) -> additions.put(id, add.asJsonObject()));

        ServerPlayNetworking.send(entity, new SyncAdditionRegistryS2CPacket(additions));

    }

}
