package ml.pluto7073.pdapi.mixin;

import ml.pluto7073.pdapi.DrinkUtil;
import ml.pluto7073.pdapi.entity.PDTrackedData;
import ml.pluto7073.pdapi.entity.effect.PDStatusEffects;
import net.minecraft.class_1293;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin extends PlayerEntityMixin {

    @Inject(at = @At("TAIL"), method = "readCustomDataFromNbt")
    public void pdapi$readPlayerCaffeineData(class_2487 nbt, CallbackInfo ci) {
        class_2487 caffeineData;
        if (nbt.method_10545("CoffeeData")) {
            caffeineData = nbt.method_10562("CoffeeData");
        } else if (nbt.method_10545("CaffeineData")) {
            caffeineData = nbt.method_10562("CaffeineData");
        } else return;

        // Caffeine Content
        if (caffeineData.method_10545("CaffeineContent")) {
            float caffeine = caffeineData.method_10583("CaffeineContent");
            this.dataTracker.method_12778(PDTrackedData.PLAYER_CAFFEINE_AMOUNT, caffeine);
        }

        // Original Caffeine Content (for math purposes)
        if (caffeineData.method_10545("OriginalCaffeineContent")) {
            float originalCaffeine = caffeineData.method_10583("OriginalCaffeineContent");
            this.dataTracker.method_12778(PDTrackedData.PLAYER_ORIGINAL_CAFFEINE_AMOUNT, originalCaffeine);
        }

        // Ticks Since Last Caffeine Change
        if (caffeineData.method_10545("TicksSinceLastCaffeine")) {
            int ticks = caffeineData.method_10550("TicksSinceLastCaffeine");
            this.dataTracker.method_12778(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE, ticks);
        }
    }

    @Inject(at = @At("TAIL"), method = "writeCustomDataToNbt")
    public void pdapi$writePlayerCaffeineData(class_2487 nbt, CallbackInfo ci) {
        class_2487 caffeineData = new class_2487();

        // Caffeine Content
        float caffeine = this.dataTracker.method_12789(PDTrackedData.PLAYER_CAFFEINE_AMOUNT);
        caffeineData.method_10548("CaffeineContent", caffeine);

        // Original Caffeine Content (For math purposes)
        float originalCaffeine = this.dataTracker.method_12789(PDTrackedData.PLAYER_ORIGINAL_CAFFEINE_AMOUNT);
        caffeineData.method_10548("OriginalCaffeineContent", originalCaffeine);

        // Ticks Since Last Caffeine Change
        int ticks = this.dataTracker.method_12789(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE);
        caffeineData.method_10569("TicksSinceLastCaffeine", ticks);

        nbt.method_10566("CaffeineData", caffeineData);
    }

    @Inject(at = @At("TAIL"), method = "tick")
    public void pdapi$updateCaffeineContent(CallbackInfo ci) {
        int ticks = this.dataTracker.method_12789(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE);
        ticks++;
        float originalCaffeine = this.dataTracker.method_12789(PDTrackedData.PLAYER_ORIGINAL_CAFFEINE_AMOUNT);
        float newCaffeine = DrinkUtil.calculateCaffeineDecay(ticks, originalCaffeine);
        this.dataTracker.method_12778(PDTrackedData.PLAYER_CAFFEINE_AMOUNT, newCaffeine);
        this.dataTracker.method_12778(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE, ticks);
    }

    @Inject(at = @At("TAIL"), method = "tick")
    public void pdapi$caffeineLevelEffects(CallbackInfo ci) {
        float caffeine = this.dataTracker.method_12789(PDTrackedData.PLAYER_CAFFEINE_AMOUNT);
        if (caffeine >= 3000.0F && !getAbilities().field_7477 && !((class_3222) (Object) this).method_6059(PDStatusEffects.CAFFEINE_OVERDOSE)) {
            this.addStatusEffect(new class_1293(PDStatusEffects.CAFFEINE_OVERDOSE, 20 * 60));
        }
    }

}
