package ml.pluto7073.pdapi.recipes;

import com.google.gson.JsonObject;
import ml.pluto7073.pdapi.DrinkUtil;
import ml.pluto7073.pdapi.addition.DrinkAdditions;
import ml.pluto7073.pdapi.block.PDBlocks;
import ml.pluto7073.pdapi.item.AbstractCustomizableDrinkItem;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import java.util.stream.Stream;

public class DrinkWorkstationRecipe implements class_1860<class_1263> {

    final class_1856 base;
    final class_1856 addition;
    final String result;
    private final class_2960 id;

    public DrinkWorkstationRecipe(class_2960 id, class_1856 base, class_1856 addition, String result) {
        this.base = base;
        this.addition = addition;
        this.result = result;
        this.id = id;
    }

    @Override
    public boolean method_8115(class_1263 inventory, class_1937 world) {
        return base.method_8093(inventory.method_5438(0)) && addition.method_8093(inventory.method_5438(1));
    }

    @Override
    public class_1799 method_8116(class_1263 inventory, class_5455 registryManager) {
        return craft(inventory);
    }

    public class_1799 craft(class_1263 inventory) {
        class_1799 stack = inventory.method_5438(0).method_7972();
        class_2499 resAdds = stack.method_7911(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY)
                .method_10554(DrinkAdditions.ADDITIONS_NBT_KEY, class_2520.field_33258);
        resAdds.add(DrinkUtil.stringAsNbt(result));
        stack.method_7911(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY).method_10566(DrinkAdditions.ADDITIONS_NBT_KEY, resAdds);

        return stack;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    @Override
    public class_1799 method_8110(class_5455 registryManager) {
        class_1799 stack = base.method_8105()[0].method_7972();
        class_2499 adds = new class_2499();
        adds.add(DrinkUtil.stringAsNbt(result));
        stack.method_7911(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY).method_10566(DrinkAdditions.ADDITIONS_NBT_KEY, adds);
        return stack;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    public boolean testAddition(class_1799 stack) {
        return addition.method_8093(stack);
    }

    public boolean testBase(class_1799 stack) {
        return base.method_8093(stack);
    }

    public class_1799 method_17447() {
        return new class_1799(PDBlocks.DRINK_WORKSTATION);
    }

    @Override
    public class_1865<?> method_8119() {
        return PDRecipeTypes.DRINK_WORKSTATION_RECIPE_SERIALIZER;
    }

    @Override
    public class_3956<?> method_17716() {
        return PDRecipeTypes.DRINK_WORKSTATION_RECIPE_TYPE;
    }

    public boolean method_31584() {
        return Stream.of(this.base, this.addition).anyMatch((ingredient) -> ingredient.method_8105().length == 0);
    }

    public static class Serializer implements class_1865<DrinkWorkstationRecipe> {

        public Serializer() {}

        @Override
        public DrinkWorkstationRecipe method_8121(class_2960 id, JsonObject jsonObject) {
            class_1856 ingredient = class_1856.method_52177(class_3518.method_15296(jsonObject, "base"));
            class_1856 ingredient2 = class_1856.method_52177(class_3518.method_15296(jsonObject, "addition"));
            String result = class_3518.method_15265(jsonObject, "result");
            return new DrinkWorkstationRecipe(id, ingredient, ingredient2, result);
        }

        @Override
        public DrinkWorkstationRecipe method_8122(class_2960 id, class_2540 buf) {
            class_1856 ingredient = class_1856.method_8086(buf);
            class_1856 ingredient2 = class_1856.method_8086(buf);
            String result = buf.method_19772();
            return new DrinkWorkstationRecipe(id, ingredient, ingredient2, result);
        }

        @Override
        public void write(class_2540 buf, DrinkWorkstationRecipe recipe) {
            recipe.base.method_8088(buf);
            recipe.addition.method_8088(buf);
            buf.method_10814(recipe.result);
        }

    }

}
