package ml.pluto7073.pdapi.config;

import ml.pluto7073.pdapi.PDAPI;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import java.io.*;
import java.util.Properties;
import java.util.function.Supplier;

public class PDServerConfig extends DrinkConfig {

    private static final String SERVER_CONFIG_FILE = "pdapi.server.properties";

    public PDServerConfig() {
        super(() -> {
            Properties p = new Properties();
            File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), SERVER_CONFIG_FILE);
            if (!file.exists()) {
                return p;
            }
            try {
                p.load(new FileReader(file));
                return p;
            } catch (IOException e) {
                PDAPI.LOGGER.error("Could not load server config for PDAPI", e);
                return new Properties();
            }
        });
    }

    public boolean doCaffeineOverdose() {
        return getBoolean("doCaffeineOverdose", true);
    }

    public void setDoCaffeineOverdose(boolean val) {
        setBoolean("doCaffeineOverdose", val);
    }

    public boolean caffeineVisibleToNonOps() {
        return getBoolean("caffeineVisibleToNonOps", true);
    }

    public void setCaffeineVisibleToNonOps(boolean val) {
        setBoolean("caffeineVisibleToNonOps", val);
    }

    public float caffeineDamageMultiplier() {
        return getFloat("caffeineDamageMultiplier", 1.0F);
    }

    public void setCaffeineDamageMultiplier(float val) {
        setFloat("caffeineDamageMultiplier", val);
    }

    public int lethalCaffeineDose() {
        return getInt("lethalCaffeineDose");
    }

    public void setLethalCaffeineDose(int val) {
        setInt("lethalCaffeineDose", val);
    }

    @Override
    public void saveProperties() {
        File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), SERVER_CONFIG_FILE);
        if (!file.exists()) {
            try {
                file.createNewFile();
            } catch (IOException e) {
                PDAPI.LOGGER.error("Could not create server config file for PDAPI", e);
                return;
            }
        }
        try {
            properties.store(new FileWriter(file), "");
        } catch (IOException e) {
            PDAPI.LOGGER.error("Could not save server config for PDAPI", e);
        }
    }

    @Override
    public void write(class_2540 buf) {

    }

    @Override
    public void read(class_2540 buf) {

    }

}
