package ml.pluto7073.pdapi.listeners;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.addition.DrinkAdditions;
import ml.pluto7073.pdapi.addition.OnDrink;
import ml.pluto7073.pdapi.addition.OnDrinkTemplate;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

public class DrinkAdditionRegisterer implements SimpleSynchronousResourceReloadListener {

    public static final class_2960 PHASE = PDAPI.asId("phase/additions");

    public DrinkAdditionRegisterer() {
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(PHASE, (player, joined) -> DrinkAdditions.send(player));
    }

    @Override
    public class_2960 getFabricId() {
        return PDAPI.asId("drink_addition_registerer");
    }

    @Override
    public void method_14491(class_3300 manager) {
        DrinkAdditions.resetRegistry();

        int i = 0;

        for (Map.Entry<class_2960, class_3298> entry : manager.method_14488("drink_additions", id -> id.method_12832().endsWith(".json")).entrySet()) {
            class_2960 id = new class_2960(entry.getKey().method_12836(),
                    entry.getKey().method_12832()
                            .replace("drink_additions/", "")
                            .replace(".json", ""));
            try (InputStream stream = entry.getValue().method_14482()) {
                JsonObject object = class_3518.method_15255(new InputStreamReader(stream));

                DrinkAdditions.register(id, loadFromJson(id, object), false);
                i++;
            } catch (IOException e) {
                PDAPI.LOGGER.error("Could not load Drink Addition " + id, e);
            }
        }

        PDAPI.LOGGER.info("Loaded {} additions", i);
    }

    public static DrinkAddition loadFromJson(class_2960 id, JsonObject object) {
        DrinkAddition.Builder builder = new DrinkAddition.Builder();
        if (object.has("caffeine")) {
            builder.caffeine(class_3518.method_15260(object, "caffeine"));
        }
        if (object.has("changesColor")) {
            builder.changesColor(class_3518.method_15270(object, "changesColor"));
        }
        if (object.has("color")) {
            builder.color(class_3518.method_15260(object, "color"));
        }
        if (object.has("maxAmount")) {
            builder.maxAmount(class_3518.method_15260(object, "maxAmount"));
        }
        if (object.has("onDrinkActions")) {
            JsonArray actionsArray = class_3518.method_15261(object, "onDrinkActions");
            for (JsonElement e : actionsArray) {
                if (!e.isJsonObject()) {
                    PDAPI.LOGGER.warn("Non-JsonObject item in 'onDrinkActions' in Drink Addition file: " + id);
                    continue;
                }
                JsonObject actionObject = e.getAsJsonObject();
                OnDrinkTemplate template;
                try {
                    template = OnDrinkTemplate.get(new class_2960(class_3518.method_15265(actionObject, "type")));
                } catch (IllegalStateException ex) {
                    PDAPI.LOGGER.error("Could not load on drink action for add-in {} because of non-existent OnDrinkTemplate {}", id.toString(), class_3518.method_15265(actionObject, "type"), ex);
                    continue;
                }
                OnDrink action = template.parseJson(id, actionObject);
                builder.addAction(action);
            }
        }
        if (object.has("weight")) {
            builder.setWeight(class_3518.method_15260(object, "weight"));
        }

        return builder.build(object);
    }

}
