/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.config;

import java.util.Properties;
import java.util.function.Supplier;
import net.minecraft.class_2540;

public abstract class DrinkConfig {
    protected final Properties properties;

    protected DrinkConfig(Supplier<Properties> propSupplier) {
        this.properties = propSupplier.get();
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultVal) {
        if (!this.properties.containsKey(key)) {
            this.properties.put(key, String.valueOf(defaultVal));
        }
        return Boolean.parseBoolean(String.valueOf(this.properties.get(key)));
    }

    public void setBoolean(String key, boolean val) {
        this.properties.put(key, String.valueOf(val));
    }

    public int getInt(String key, int defaultVal) {
        if (!this.properties.containsKey(key)) {
            this.properties.put(key, String.valueOf(defaultVal));
        }
        return Integer.parseInt(this.properties.getProperty(key));
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public void setInt(String key, int i) {
        this.properties.put(key, String.valueOf(i));
    }

    public float getFloat(String key, float defaultVal) {
        if (!this.properties.containsKey(key)) {
            this.properties.put(key, String.valueOf(defaultVal));
        }
        return Float.parseFloat(this.properties.getProperty(key));
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public void setFloat(String key, float f) {
        this.properties.put(key, String.valueOf(f));
    }

    public String getString(String key, String defaultVal) {
        if (!this.properties.containsKey(key)) {
            this.properties.put(key, defaultVal);
        }
        return this.properties.getProperty(key);
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public void setString(String key, String s) {
        this.properties.put(key, s);
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> enumClass, T defaultVal) {
        if (!this.properties.containsKey(key)) {
            this.properties.put(key, defaultVal.name());
        }
        return Enum.valueOf(enumClass, this.properties.getProperty(key));
    }

    public <T extends Enum<T>> void setEnum(String key, T val) {
        this.properties.put(key, val.name());
    }

    public abstract void saveProperties();

    public abstract void write(class_2540 var1);

    public abstract void read(class_2540 var1);
}

