/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.config.DrinkConfig;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;

public class PDServerConfig
extends DrinkConfig {
    private static final String SERVER_CONFIG_FILE = "pdapi.server.properties";

    public PDServerConfig() {
        super(() -> {
            Properties p = new Properties();
            File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), SERVER_CONFIG_FILE);
            if (!file.exists()) {
                return p;
            }
            try {
                p.load(new FileReader(file));
                return p;
            }
            catch (IOException e) {
                PDAPI.LOGGER.error("Could not load server config for PDAPI", (Throwable)e);
                return new Properties();
            }
        });
    }

    public boolean doCaffeineOverdose() {
        return this.getBoolean("doCaffeineOverdose", true);
    }

    public void setDoCaffeineOverdose(boolean val) {
        this.setBoolean("doCaffeineOverdose", val);
    }

    public boolean caffeineVisibleToNonOps() {
        return this.getBoolean("caffeineVisibleToNonOps", true);
    }

    public void setCaffeineVisibleToNonOps(boolean val) {
        this.setBoolean("caffeineVisibleToNonOps", val);
    }

    public float caffeineDamageMultiplier() {
        return this.getFloat("caffeineDamageMultiplier", 1.0f);
    }

    public void setCaffeineDamageMultiplier(float val) {
        this.setFloat("caffeineDamageMultiplier", val);
    }

    public int lethalCaffeineDose() {
        return this.getInt("lethalCaffeineDose");
    }

    public void setLethalCaffeineDose(int val) {
        this.setInt("lethalCaffeineDose", val);
    }

    @Override
    public void saveProperties() {
        File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), SERVER_CONFIG_FILE);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                PDAPI.LOGGER.error("Could not create server config file for PDAPI", (Throwable)e);
                return;
            }
        }
        try {
            this.properties.store(new FileWriter(file), "");
        }
        catch (IOException e) {
            PDAPI.LOGGER.error("Could not save server config for PDAPI", (Throwable)e);
        }
    }

    @Override
    public void write(class_2540 buf) {
    }

    @Override
    public void read(class_2540 buf) {
    }
}

