/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.item;

import java.util.HashMap;
import java.util.List;
import ml.pluto7073.pdapi.DrinkUtil;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.addition.DrinkAdditions;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCustomizableDrinkItem
extends class_1792 {
    public static final String DRINK_DATA_NBT_KEY = "DrinkData";
    private static final int MAX_USE_TIME = 32;
    protected final Temperature baseTemperature;
    protected final class_1792 baseItem;

    protected AbstractCustomizableDrinkItem(class_1792 baseItem, Temperature baseTemperature, class_1792.class_1793 settings) {
        super(settings);
        this.baseTemperature = baseTemperature;
        this.baseItem = baseItem;
    }

    public Temperature getDrinkTemperature(class_1799 stack) {
        return this.baseTemperature;
    }

    public int getCaffeineContent(class_1799 stack) {
        int caffeine = 0;
        for (DrinkAddition a : DrinkUtil.getAdditionsFromStack(stack)) {
            caffeine += a.getCaffeine();
        }
        return caffeine;
    }

    public int method_7881(class_1799 stack) {
        return 32;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8946;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        class_1657 playerEntity;
        class_1657 class_16572 = playerEntity = user instanceof class_1657 ? (class_1657)user : null;
        if (playerEntity instanceof class_3222) {
            class_174.field_1198.method_8821((class_3222)playerEntity, stack);
        }
        if (!world.field_9236) {
            DrinkAddition[] additions;
            for (DrinkAddition addition : additions = DrinkUtil.getAdditionsFromStack(stack)) {
                addition.onDrink(stack, world, user);
            }
            int caffeine = this.getCaffeineContent(stack);
            if (playerEntity != null) {
                float currentCaffeine = DrinkUtil.getPlayerCaffeine(playerEntity);
                DrinkUtil.setPlayerCaffeine(playerEntity, currentCaffeine += (float)caffeine);
            }
        }
        if (playerEntity != null) {
            playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this));
            if (!playerEntity.method_31549().field_7477) {
                stack.method_7934(1);
            }
        }
        if (playerEntity == null || !playerEntity.method_31549().field_7477) {
            if (stack.method_7960()) {
                return new class_1799((class_1935)this.baseItem);
            }
            if (playerEntity != null) {
                playerEntity.method_31548().method_7394(new class_1799((class_1935)this.baseItem));
            }
        }
        user.method_32876(class_5712.field_28734);
        return stack;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        float caffeine = 0.0f;
        DrinkAddition[] addIns = DrinkUtil.getAdditionsFromStack(stack);
        HashMap<class_2960, Integer> additionCounts = new HashMap<class_2960, Integer>();
        for (DrinkAddition addIn : addIns) {
            if (addIn == DrinkAdditions.EMPTY) continue;
            caffeine += (float)addIn.getCaffeine();
            class_2960 id2 = DrinkAdditions.getId(addIn);
            if (additionCounts.containsKey(id2)) {
                int count2 = (Integer)additionCounts.get(id2);
                additionCounts.put(id2, ++count2);
                continue;
            }
            additionCounts.put(id2, 1);
        }
        additionCounts.forEach((id, count) -> tooltip.add((class_2561)class_2561.method_43469((String)DrinkAdditions.REGISTRY.get(id).getTranslationKey(), (Object[])new Object[]{count}).method_27692(class_124.field_1080)));
        if (caffeine > 0.0f) {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.pdapi.caffeine_content", (Object[])new Object[]{Float.valueOf(caffeine)}).method_27692(class_124.field_1075));
        }
    }

    public static enum Temperature {
        BURNT,
        HOT,
        NORMAL,
        COLD,
        FROZEN;

    }
}

