package ml.pluto7073.pdapi.addition;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import ml.pluto7073.pdapi.PDAPI;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_4019;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@FunctionalInterface
public interface OnDrinkTemplate {

    HashMap<class_2960, OnDrinkTemplate> REGISTRY = new HashMap<>();

    OnDrinkTemplate APPLY_STATUS_EFFECT = register("apply_status_effect", (id, onDrinkData) -> {
        class_2960 effect = new class_2960(class_3518.method_15265(onDrinkData, "effect"));
        int duration = class_3518.method_15260(onDrinkData, "duration");
        int amplifier = class_3518.method_15260(onDrinkData, "amplifier");
        class_1291 statusEffect = class_7923.field_41174.method_10223(effect);
        assert statusEffect != null;

        return new OnDrink() {
            @Override
            public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
                user.method_6092(new class_1293(statusEffect, duration, amplifier));
            }

            @Override
            public JsonObject toJson() {
                return onDrinkData;
            }
        };
    });

    OnDrinkTemplate DEAL_DAMAGE = register("deal_damage", (id, onDrinkData) -> {
        float amount = class_3518.method_15259(onDrinkData, "amount");
        class_2960 damageSource = new class_2960(class_3518.method_15265(onDrinkData, "source"));
        return new OnDrink() {
            @Override
            public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
                class_5321<class_8110> type = class_5321.method_29179(class_7924.field_42534, damageSource);
                user.method_5643(user.method_48923().method_48795(type), amount);
            }

            @Override
            public JsonObject toJson() {
                return onDrinkData;
            }
        };
    });

    OnDrinkTemplate RESTORE_HUNGER = register("restore_hunger", (id, onDrinkData) -> {
        int food = class_3518.method_15260(onDrinkData, "food");
        int saturation = class_3518.method_15260(onDrinkData, "saturation");
        return new OnDrink() {
            @Override
            public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
                if (!(user instanceof class_1657 player)) return;
                player.method_7344().method_7585(food, saturation);
            }

            @Override
            public JsonObject toJson() {
                return onDrinkData;
            }
        };
    });

    OnDrinkTemplate CLEAR_HARMFUL_EFFECTS = register("clear_harmful_effects", (id, onDrinkData) -> new OnDrink() {
        @Override
        public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
            Collection<class_1293> statusEffects = new ArrayList<>(user.method_6026());
            if (statusEffects.isEmpty()) return;
            for (class_1293 instance : statusEffects) {
                if (!instance.method_5579().method_5573()) user.method_6016(instance.method_5579());
            }
        }

        @Override
        public JsonObject toJson() {
            return onDrinkData;
        }
    });

    OnDrinkTemplate CHORUS_TELEPORT = register("chorus_teleport", (id, onDrinkData) -> {
        int radius = class_3518.method_15260(onDrinkData, "maxRadius");
        return new OnDrink() {
            @Override
            public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
                double d = user.method_23317();
                double e = user.method_23318();
                double f = user.method_23321();

                for(int i = 0; i < 16; ++i) {
                    double g = user.method_23317() + (user.method_6051().method_43058() - 0.5) * radius * 2;
                    double h = class_3532.method_15350(user.method_23318() + (double)(user.method_6051().method_43048(radius * 2) - radius), level.method_31607(), level.method_31607() + ((class_3218)level).method_32819() - 1);
                    double j = user.method_23321() + (user.method_6051().method_43058() - 0.5) * radius * 2;
                    if (user.method_5765()) {
                        user.method_5848();
                    }

                    class_243 vec3d = user.method_19538();
                    if (user.method_6082(g, h, j, true)) {
                        level.method_32888(class_5712.field_39446, vec3d, class_5712.class_7397.method_43285(user));
                        class_3414 soundEvent = user instanceof class_4019 ? class_3417.field_24630 : class_3417.field_14890;
                        level.method_43128(null, d, e, f, soundEvent, class_3419.field_15248, 1.0F, 1.0F);
                        user.method_5783(soundEvent, 1.0F, 1.0F);
                        user.method_38785();
                        break;
                    }
                }
            }

            @Override
            public JsonObject toJson() {
                return onDrinkData;
            }
        };
    });

    static OnDrinkTemplate register(class_2960 id, OnDrinkTemplate template) {
        REGISTRY.put(id, template);
        return template;
    }

    private static OnDrinkTemplate register(String id, OnDrinkTemplate template) {
        return register(PDAPI.asId(id), template);
    }

    static OnDrinkTemplate get(class_2960 id) {
        OnDrinkTemplate template = REGISTRY.get(id);
        if (template == null) throw new IllegalArgumentException("No valid OnDrinkTemplate exists for identifier " + id.toString());
        return template;
    }

    OnDrink parseJson(class_2960 id, JsonObject onDrinkData);

}
