/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.addition;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.addition.DrinkAdditions;
import ml.pluto7073.pdapi.addition.OnDrink;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class DrinkAddition {
    private final OnDrink[] actions;
    private final boolean changesColor;
    private final int color;
    private final int caffeine;
    private final int maxAmount;
    private final int currentWeight;
    private final String name;
    private final JsonObject originalData;

    public DrinkAddition(OnDrink[] actions, boolean changesColor, int color, int caffeine, int maxAmount, @Nullable String name, JsonObject originalData) {
        this(actions, changesColor, color, caffeine, maxAmount, name, originalData, 0);
    }

    protected DrinkAddition(OnDrink[] actions, boolean changesColor, int color, int caffeine, int maxAmount, @Nullable String name, JsonObject originalData, int currentWeight) {
        this.actions = actions;
        this.changesColor = changesColor;
        this.color = color;
        this.caffeine = caffeine;
        this.maxAmount = maxAmount;
        this.originalData = originalData;
        this.currentWeight = currentWeight;
        this.name = name;
    }

    public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
        for (OnDrink action : this.actions) {
            action.onDrink(stack, level, user);
        }
    }

    public boolean changesColor() {
        return this.changesColor;
    }

    public int getColor() {
        return this.color;
    }

    public int getCaffeine() {
        return this.caffeine;
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public int getCurrentWeight() {
        return this.currentWeight;
    }

    public JsonObject asJsonObject() {
        return this.originalData;
    }

    public String getTranslationKey() {
        if (this.name != null) {
            return this.name;
        }
        try {
            class_2960 id = DrinkAdditions.getId(this);
            return "drink_addition." + id.method_12836() + "." + id.method_12832();
        }
        catch (IllegalArgumentException e) {
            PDAPI.LOGGER.error("Couldn't get translation key for a drink addition", (Throwable)e);
            return "drink_addition.pdapi.empty";
        }
    }

    public static class Builder {
        private final List<OnDrink> actions = new ArrayList<OnDrink>();
        private boolean changesColor = false;
        private int color = 0;
        private int caffeine = 0;
        private int maxAmount = 0;
        private int weight = 0;
        private String name = null;

        public Builder addAction(OnDrink action) {
            this.actions.add(action);
            return this;
        }

        public Builder changesColor(boolean changesColor) {
            this.changesColor = changesColor;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        public Builder caffeine(int caffeine) {
            this.caffeine = caffeine;
            return this;
        }

        public Builder maxAmount(int amount) {
            this.maxAmount = amount;
            return this;
        }

        public Builder setWeight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public DrinkAddition build(JsonObject data) {
            return new DrinkAddition(this.actions.toArray(new OnDrink[0]), this.changesColor, this.color, this.caffeine, this.maxAmount, this.name, data, this.weight);
        }
    }
}

