/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.listeners;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.addition.DrinkAdditions;
import ml.pluto7073.pdapi.addition.OnDrink;
import ml.pluto7073.pdapi.addition.OnDrinkTemplate;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

public class DrinkAdditionRegisterer
implements SimpleSynchronousResourceReloadListener {
    public static final class_2960 PHASE = PDAPI.asId("phase/additions");

    public DrinkAdditionRegisterer() {
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(PHASE, (player, joined) -> DrinkAdditions.send(player));
    }

    public class_2960 getFabricId() {
        return PDAPI.asId("drink_addition_registerer");
    }

    public void method_14491(class_3300 manager) {
        DrinkAdditions.resetRegistry();
        int i = 0;
        for (Map.Entry entry : manager.method_14488("drink_additions", id -> id.method_12832().endsWith(".json")).entrySet()) {
            class_2960 id2 = new class_2960(((class_2960)entry.getKey()).method_12836(), ((class_2960)entry.getKey()).method_12832().replace("drink_additions/", "").replace(".json", ""));
            try {
                InputStream stream = ((class_3298)entry.getValue()).method_14482();
                try {
                    JsonObject object = class_3518.method_15255((Reader)new InputStreamReader(stream));
                    DrinkAdditions.register(id2, DrinkAdditionRegisterer.loadFromJson(id2, object), false);
                    ++i;
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                PDAPI.LOGGER.error("Could not load Drink Addition " + id2, (Throwable)e);
            }
        }
        PDAPI.LOGGER.info("Loaded {} additions", (Object)i);
    }

    public static DrinkAddition loadFromJson(class_2960 id, JsonObject object) {
        DrinkAddition.Builder builder = new DrinkAddition.Builder();
        if (object.has("caffeine")) {
            builder.caffeine(class_3518.method_15260((JsonObject)object, (String)"caffeine"));
        }
        if (object.has("changesColor")) {
            builder.changesColor(class_3518.method_15270((JsonObject)object, (String)"changesColor"));
        }
        if (object.has("color")) {
            builder.color(class_3518.method_15260((JsonObject)object, (String)"color"));
        }
        if (object.has("maxAmount")) {
            builder.maxAmount(class_3518.method_15260((JsonObject)object, (String)"maxAmount"));
        }
        if (object.has("onDrinkActions")) {
            JsonArray actionsArray = class_3518.method_15261((JsonObject)object, (String)"onDrinkActions");
            for (JsonElement e : actionsArray) {
                OnDrinkTemplate template;
                if (!e.isJsonObject()) {
                    PDAPI.LOGGER.warn("Non-JsonObject item in 'onDrinkActions' in Drink Addition file: " + id);
                    continue;
                }
                JsonObject actionObject = e.getAsJsonObject();
                try {
                    template = OnDrinkTemplate.get(new class_2960(class_3518.method_15265((JsonObject)actionObject, (String)"type")));
                }
                catch (IllegalStateException ex) {
                    PDAPI.LOGGER.error("Could not load on drink action for add-in {} because of non-existent OnDrinkTemplate {}", (Object)id.toString(), (Object)class_3518.method_15265((JsonObject)actionObject, (String)"type"), (Object)ex);
                    continue;
                }
                OnDrink action = template.parseJson(id, actionObject);
                builder.addAction(action);
            }
        }
        if (object.has("weight")) {
            builder.setWeight(class_3518.method_15260((JsonObject)object, (String)"weight"));
        }
        if (object.has("name")) {
            builder.name(class_3518.method_15265((JsonObject)object, (String)"name"));
        }
        return builder.build(object);
    }
}

