package ml.pluto7073.pdapi;

import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.addition.DrinkAdditions;
import ml.pluto7073.pdapi.addition.chemicals.ConsumableChemicalRegistry;
import ml.pluto7073.pdapi.item.AbstractCustomizableDrinkItem;
import ml.pluto7073.pdapi.item.PDItems;
import ml.pluto7073.pdapi.recipes.DrinkWorkstationRecipe;
import ml.pluto7073.pdapi.recipes.PDRecipeTypes;
import ml.pluto7073.pdapi.specialty.SpecialtyDrink;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import java.util.*;

public final class DrinkUtil {

    private static final HashMap<String, Converter> OLD_CONVERSION_REGISTRY = new HashMap<>();
    private static final double CAFFEINE_HALF_LIFE_TICKS = 2500.0;

    public static void convertStackFromPlutosCoffee(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545("Coffee")) return;
        Stack<String> currentPath = new Stack<>();
        currentPath.push("Coffee");
        class_2487 oldCoffeeData = nbt.method_10562("Coffee");
        handleCompound(currentPath, oldCoffeeData);
        nbt.method_10566(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY, oldCoffeeData);
        nbt.method_10551("Coffee");
    }

    private static void handleCompound(Stack<String> currentPath, class_2487 compound) {
        for (String key : compound.method_10541()) {
            class_2520 element = compound.method_10580(key);
            if (element == null) continue;
            currentPath.push(key);
            String current = convertPathStackToString(currentPath);
            if (OLD_CONVERSION_REGISTRY.containsKey(current)) {
                element = OLD_CONVERSION_REGISTRY.get(current).convert(element);
                compound.method_10566(key, element);
                continue;
            }
            if (element.method_10711() == class_2487.field_33260) {
                handleCompound(currentPath, (class_2487) element);
            }
            currentPath.pop();
        }
    }

    public static class_1263 copyContainerContents(class_1263 source) {
        class_1263 container = new class_1277(source.method_5439());
        for (int i = 0; i < source.method_5439(); i++) {
            container.method_5447(i, source.method_5438(i).method_7972());
        }
        return container;
    }

    public static DrinkAddition[] getAdditionsFromStack(class_1799 stack) {
        convertStackFromPlutosCoffee(stack);
        class_2487 drinkData = stack.method_7911(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY);
        class_2499 additions = drinkData.method_10554(DrinkAdditions.ADDITIONS_NBT_KEY, class_2520.field_33258);
        ArrayList<DrinkAddition> additionsList = new ArrayList<>();
        for (int i = 0; i < additions.size(); i++) {
            String id = additions.method_10608(i);
            class_2960 identifier = new class_2960(id);
            additionsList.add(DrinkAdditions.get(identifier));
        }
        return additionsList.toArray(new DrinkAddition[0]);
    }

    public static void registerOldToNewConverter(String nbtPath, Converter converter) {
        OLD_CONVERSION_REGISTRY.put(nbtPath, converter);
    }

    private static String convertPathStackToString(Stack<String> stack) {
        if (stack.isEmpty()) return "";
        StringBuilder builder = new StringBuilder(stack.get(0));
        for (int i = 1; i < stack.size(); i++) {
            builder.append("/").append(stack.get(i));
        }
        return builder.toString();
    }

    public static class_2520 stringAsNbt(String s) {
        class_2487 compound = new class_2487();
        compound.method_10582("string", s);
        return compound.method_10580("string");
    }

    public static float calculateCaffeineDecay(int ticks, float originalCaffeine) {
        double exp = Math.pow(0.5, ticks / CAFFEINE_HALF_LIFE_TICKS);
        return (float) (exp * originalCaffeine);
    }

    public static float getPlayerCaffeine(class_1657 player) {
        return ConsumableChemicalRegistry.CAFFEINE.get(player);
    }

    public static SpecialtyDrink getSpecialDrink(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        String id = nbt.method_10558("Drink");
        SpecialtyDrink drink = SpecialtyDrink.DRINKS.get(new class_2960(id));
        if (drink == null) throw new IllegalArgumentException("Drink " + id + " does not exist");
        return drink;
    }

    public static class_1799 setSpecialDrink(class_1799 stack, SpecialtyDrink drink) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10566("Drink", class_2519.method_23256(drink.id().toString()));
        stack.method_7980(nbt);
        return stack;
    }

    public static int getDrinkColor(class_1799 stack) {
        if (!stack.method_31574(PDItems.SPECIALTY_DRINK)) return -1;
        try {
            SpecialtyDrink drink = getSpecialDrink(stack);
            return drink.color();
        } catch (IllegalArgumentException e) {
            return 0xf918c5;
        }
    }

    public static class_1856 additionToIngredient(class_2960 additionId) {
        class_1937 level = class_310.method_1551().field_1687;
        if (level == null) {
            PDAPI.LOGGER.warn("Ingredient list for \"{}\" could not be determined cause you are not in a world", additionId);
            return class_1856.field_9017;
        }
        List<DrinkWorkstationRecipe> recipes = level.method_8433().method_30027(PDRecipeTypes.DRINK_WORKSTATION_RECIPE_TYPE)
                .stream().filter(r -> r.getResultId().equals(additionId)).toList();
        if (recipes.isEmpty()) return class_1856.field_9017;
        List<class_1799> matchingStacks = new ArrayList<>();
        recipes.forEach(r -> matchingStacks.addAll(Arrays.asList(r.getAddition().method_8105())));
        if (matchingStacks.isEmpty()) return class_1856.field_9017;
        return class_1856.method_26964(matchingStacks.stream());
    }

    public static class_1856 getValidBasesForAddition(class_2960 additionId) {
        class_1937 level = class_310.method_1551().field_1687;
        if (level == null) {
            PDAPI.LOGGER.warn("Valid bases for \"{}\" can only be retrieved when a level is loaded", additionId);
            return class_1856.field_9017;
        }
        List<DrinkWorkstationRecipe> recipes = level.method_8433().method_30027(PDRecipeTypes.DRINK_WORKSTATION_RECIPE_TYPE)
                .stream().filter(r -> r.getResultId().equals(additionId)).toList();
        if (recipes.isEmpty()) return class_1856.field_9017;
        List<class_1799> matchingStacks = new ArrayList<>();
        recipes.forEach(r -> matchingStacks.addAll(Arrays.asList(r.getBase().method_8105())));
        if (matchingStacks.isEmpty()) return class_1856.field_9017;
        return class_1856.method_26964(matchingStacks.stream());
    }

    public interface Converter<T extends class_2520> {
        T convert(T startingElement);
    }

}
