package ml.pluto7073.pdapi.addition.chemicals;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import ml.pluto7073.pdapi.DrinkUtil;
import ml.pluto7073.pdapi.command.PDCommands;
import ml.pluto7073.pdapi.entity.PDTrackedData;
import ml.pluto7073.pdapi.entity.effect.PDMobEffects;
import ml.pluto7073.pdapi.gamerule.PDGameRules;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CaffeineHandler implements ConsumableChemicalHandler {

    @Override
    public void tickPlayer(class_1657 player) {
        int ticks = player.method_5841().method_12789(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE);
        ticks++;
        float originalCaffeine = player.method_5841().method_12789(PDTrackedData.PLAYER_ORIGINAL_CAFFEINE_AMOUNT);
        float newCaffeine = DrinkUtil.calculateCaffeineDecay(ticks, originalCaffeine);
        player.method_5841().method_12778(PDTrackedData.PLAYER_CAFFEINE_AMOUNT, newCaffeine);
        player.method_5841().method_12778(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE, ticks);
    }

    @Override
    public float get(class_1657 player) {
        return player.method_5841().method_12789(PDTrackedData.PLAYER_CAFFEINE_AMOUNT).intValue();
    }

    @Override
    public void add(class_1657 player, float amount) {
        set(player, get(player) + amount);
    }

    @Override
    public void set(class_1657 player, float amount) {
        player.method_5841().method_12778(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE, 0);
        player.method_5841().method_12778(PDTrackedData.PLAYER_CAFFEINE_AMOUNT, amount);
        player.method_5841().method_12778(PDTrackedData.PLAYER_ORIGINAL_CAFFEINE_AMOUNT, amount);
    }

    @Override
    public Collection<class_1293> getEffectsForAmount(float amount, class_1657 player) {
        ArrayList<class_1293> list = new ArrayList<>();
        if (amount >= 100) {
            list.add(new class_1293(class_1294.field_5904, 600));
        }
        if (amount >= 150) {
            list.add(new class_1293(class_1294.field_5917, 600));
        }
        if (amount >= 300) {
            list.add(new class_1293(class_1294.field_5903, 600));
        }
        if (amount >= 400 && FabricLoader.getInstance().isModLoaded("dehydration")) {
            //noinspection DataFlowIssue
            list.add(new class_1293(class_7923.field_41174.method_10223(new class_2960("dehydration:thirst_effect")),
                    600, 0));
        }
        if (amount >= 450) {
            list.add(new class_1293(class_1294.field_5904, 600, 1));
        }
        if (amount >= 500) {
            list.add(new class_1293(class_1294.field_5913, 600));
        }
        if (amount >= 600) {
            list.add(new class_1293(class_1294.field_5917, 600, 1));
        }
        if (amount >= 700) {
            list.add(new class_1293(class_1294.field_5913, 600, 1));
        }
        int lethalCaffeineDose = player.method_37908().method_8450().method_8356(PDGameRules.LETHAL_CAFFEINE_DOSE);
        boolean overdose = player.method_37908().method_8450().method_8355(PDGameRules.DO_CAFFEINE_OVERDOSE);
        if (overdose && amount >= lethalCaffeineDose) {
            list.add(new class_1293(PDMobEffects.CAFFEINE_OVERDOSE, 20 * 60));
        }
        return list;
    }

    @Override
    public String getName() {
        return "caffeine";
    }

    @Override
    public void saveToTag(class_2945 data, class_2487 tag) {
        class_2487 caffeineData = new class_2487();

        // Caffeine Content
        float caffeine = data.method_12789(PDTrackedData.PLAYER_CAFFEINE_AMOUNT);
        caffeineData.method_10548("CaffeineContent", caffeine);

        // Original Caffeine Content (For math purposes)
        float originalCaffeine = data.method_12789(PDTrackedData.PLAYER_ORIGINAL_CAFFEINE_AMOUNT);
        caffeineData.method_10548("OriginalCaffeineContent", originalCaffeine);

        // Ticks Since Last Caffeine Change
        int ticks = data.method_12789(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE);
        caffeineData.method_10569("TicksSinceLastCaffeine", ticks);

        tag.method_10566("CaffeineData", caffeineData);
    }

    @Override
    public void loadFromTag(class_2945 data, class_2487 tag) {
        class_2487 caffeineData;
        if (tag.method_10545("CoffeeData")) {
            caffeineData = tag.method_10562("CoffeeData");
        } else if (tag.method_10545("CaffeineData")) {
            caffeineData = tag.method_10562("CaffeineData");
        } else return;

        // Caffeine Content
        if (caffeineData.method_10545("CaffeineContent")) {
            float caffeine = caffeineData.method_10583("CaffeineContent");
            data.method_12778(PDTrackedData.PLAYER_CAFFEINE_AMOUNT, caffeine);
        }

        // Original Caffeine Content (for math purposes)
        if (caffeineData.method_10545("OriginalCaffeineContent")) {
            float originalCaffeine = caffeineData.method_10583("OriginalCaffeineContent");
            data.method_12778(PDTrackedData.PLAYER_ORIGINAL_CAFFEINE_AMOUNT, originalCaffeine);
        }

        // Ticks Since Last Caffeine Change
        if (caffeineData.method_10545("TicksSinceLastCaffeine")) {
            int ticks = caffeineData.method_10550("TicksSinceLastCaffeine");
            data.method_12778(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE, ticks);
        }
    }

    @Override
    public void defineDataForPlayer(class_2945 data) {
        data.method_12784(PDTrackedData.PLAYER_CAFFEINE_AMOUNT, 0F);
        data.method_12784(PDTrackedData.PLAYER_ORIGINAL_CAFFEINE_AMOUNT, 0F);
        data.method_12784(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE, 0);
    }

    @Override
    public void appendTooltip(List<class_2561> tooltip, float caffeine) {
        if (caffeine > 0) tooltip.add(class_2561.method_43469("tooltip.pdapi.caffeine_content", caffeine).method_27692(class_124.field_1075));
    }

    @Override
    public @Nullable LiteralArgumentBuilder<class_2168> getDrinkSubcommand() {
        return PDCommands.caffeine();
    }

}
