package ml.pluto7073.pdapi.recipes;

import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.specialty.SpecialtyDrink;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

public final class PDRecipeTypes {

    public static final class_3956<DrinkWorkstationRecipe> DRINK_WORKSTATION_RECIPE_TYPE;
    public static final class_1865<DrinkWorkstationRecipe> DRINK_WORKSTATION_RECIPE_SERIALIZER;

    public static final class_3956<SpecialtyDrink> SPECIALTY_DRINK_RECIPE_TYPE;
    public static final class_1865<SpecialtyDrink> SPECIALTY_DRINK_RECIPE_SERIALIZER;

    public static <S extends class_1865<T>, T extends class_1860<?>> S registerRecipeSerializer(String id, S serializer) {
        return class_2378.method_10230(class_7923.field_41189, PDAPI.asId(id), serializer);
    }

    public static <T extends class_1860<?>> class_3956<T> registerType(String id) {
        class_2960 i = PDAPI.asId(id);
        return class_2378.method_10230(class_7923.field_41188, i, new class_3956<T>() {
            public String toString() {
                return i.toString();
            }
        });
    }

    static {
        DRINK_WORKSTATION_RECIPE_SERIALIZER = registerRecipeSerializer("drink_workstation", new DrinkWorkstationRecipe.Serializer());
        DRINK_WORKSTATION_RECIPE_TYPE = registerType("drink_workstation");

        SPECIALTY_DRINK_RECIPE_SERIALIZER = registerRecipeSerializer("specialty_drink", new SpecialtyDrink.Serializer());
        SPECIALTY_DRINK_RECIPE_TYPE = registerType("specialty_drink");
    }

    public static void init() {}

}
