package ml.pluto7073.pdapi.specialty;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ml.pluto7073.pdapi.DrinkUtil;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.addition.DrinkAdditions;
import ml.pluto7073.pdapi.addition.OnDrink;
import ml.pluto7073.pdapi.addition.OnDrinkTemplate;
import ml.pluto7073.pdapi.addition.chemicals.ConsumableChemicalRegistry;
import ml.pluto7073.pdapi.item.AbstractCustomizableDrinkItem;
import ml.pluto7073.pdapi.item.PDItems;
import ml.pluto7073.pdapi.networking.NetworkingUtils;
import ml.pluto7073.pdapi.recipes.DrinkWorkstationRecipe;
import ml.pluto7073.pdapi.recipes.PDRecipeTypes;
import ml.pluto7073.pdapi.tag.PDTags;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_6328;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

@class_6328
public record SpecialtyDrink(class_2960 id, class_1792 base, class_2960[] steps, OnDrink[] actions, int color, HashMap<String, Integer> chemicals, String name) implements class_1860<class_1263> {

    public static final HashMap<class_2960, SpecialtyDrink> DRINKS = new HashMap<>();

    public SpecialtyDrink(class_2960 id, class_1792 base, class_2960[] steps, OnDrink[] actions, int color, HashMap<String, Integer> chemicals, @Nullable String name) {
        this.id = id;
        this.base = base;
        this.steps = steps;
        this.actions = actions;
        this.color = color;
        this.chemicals = chemicals;
        this.name = name != null ? name : "drink." + id.method_12836() + "." + id.method_12832();
        DRINKS.put(id, this);
    }

    public class_1799 getAsItem() {
        return DrinkUtil.setSpecialDrink(new class_1799(PDItems.SPECIALTY_DRINK, 1), this);
    }

    public class_1799 getAsOriginalItemWithAdditions(class_1799 source) {
        class_1799 stack = new class_1799(base, 1);
        class_2487 ogData = source.method_7911(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY);
        class_2487 drinkData = ogData.method_10553();
        class_2499 list = new class_2499();
        for (class_2960 step : steps) {
            list.add(class_2519.method_23256(step.toString()));
        }
        list.addAll(ogData.method_10554(DrinkAdditions.ADDITIONS_NBT_KEY, class_2520.field_33258));
        drinkData.method_10566(DrinkAdditions.ADDITIONS_NBT_KEY, list);
        stack.method_7948().method_10566(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY, drinkData);
        return stack;
    }

    @Override
    public boolean method_8115(class_1263 container, class_1937 level) {
        class_1799 currentResult = container.method_5438(0);
        if (!currentResult.method_31574(base)) return false;
        class_2499 additions = currentResult.method_7911(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY)
                .method_10554(DrinkAdditions.ADDITIONS_NBT_KEY, class_2519.field_33258);
        if (steps.length != additions.size()) return false;
        for (int i = 0; i < additions.size(); i++) {
            String actual = additions.method_10608(i);
            String wanted = steps[i].toString();
            if (!actual.equals(wanted)) return false;
        }
        return true;
    }

    @Override
    public class_1799 method_8116(class_1263 container, class_5455 registryAccess) {
        return getAsItem();
    }

    @Override
    public boolean method_8113(int width, int height) {
        return true;
    }

    @Override
    public class_1799 method_8110(class_5455 registryAccess) {
        return getAsItem();
    }

    @Override
    public class_2960 method_8114() {
        return id;
    }

    @Override
    public class_1865<?> method_8119() {
        return PDRecipeTypes.SPECIALTY_DRINK_RECIPE_SERIALIZER;
    }

    @Override
    public class_3956<?> method_17716() {
        return PDRecipeTypes.SPECIALTY_DRINK_RECIPE_TYPE;
    }

    public List<class_1856> stepsToIngredientList() {
        List<class_1856> ingredients = new ArrayList<>();
        for (class_2960 addition : steps) {
            ingredients.add(DrinkUtil.additionToIngredient(addition));
        }
        return ingredients;
    }

    @class_6328
    public static class Serializer implements class_1865<SpecialtyDrink> {

        public Serializer() {}

        @Override
        public SpecialtyDrink method_8121(class_2960 id, JsonObject data) {
            class_1792 base = class_7923.field_41178.method_10223(new class_2960(class_3518.method_15265(data, "base")));
            JsonArray additionsJson = class_3518.method_15261(data, "additions");
            List<class_2960> additions = new ArrayList<>();
            for (JsonElement e : additionsJson) {
                additions.add(new class_2960(e.getAsString()));
            }
            if (additions.size() > 10) throw new IllegalStateException("Specialty Drink \"" + id.toString() + "\" cannot have more than 10 steps");

            HashMap<String, Integer> chemicals = new HashMap<>();
            ConsumableChemicalRegistry.forEach(handler -> {
                if (data.has(handler.getName())) {
                    chemicals.put(handler.getName(), class_3518.method_15260(data, handler.getName()));
                }
            });

            int color = class_3518.method_15260(data, "color");
            JsonArray actionsArray = class_3518.method_15261(data, "onDrinkActions");
            List<OnDrink> actions = new ArrayList<>();
            for (JsonElement e : actionsArray) {
                if (!e.isJsonObject()) {
                    PDAPI.LOGGER.warn("Non-JsonObject item in 'onDrinkActions' in Specialty file: {}", id);
                    continue;
                }
                JsonObject actionObject = e.getAsJsonObject();
                OnDrinkTemplate template;
                try {
                    template = OnDrinkTemplate.get(new class_2960(class_3518.method_15265(actionObject, "type")));
                } catch (IllegalStateException ex) {
                    PDAPI.LOGGER.error("Could not load on drink action for add-in {} because of non-existent OnDrinkTemplate {}", id.toString(), class_3518.method_15265(actionObject, "type"), ex);
                    continue;
                }
                actions.add(template.parseJson(id, actionObject));
            }
            String name = null;
            if (data.has("name")) {
                name = class_3518.method_15265(data, "name");
            }
            return new SpecialtyDrink(id, base, additions.toArray(new class_2960[0]), actions.toArray(new OnDrink[0]), color, chemicals, name);
        }

        @Override
        public SpecialtyDrink method_8122(class_2960 id, class_2540 buf) {
            class_2960 base = buf.method_10810();
            class_2960[] steps = NetworkingUtils.listFromNetwork(buf, class_2540::method_10810).toArray(new class_2960[0]);
            HashMap<String, Integer> chemicals = Maps.newHashMap(buf.method_34067(class_2540::method_19772, class_2540::readInt));
            int color = buf.readInt();
            List<JsonObject> objects = NetworkingUtils.listFromNetwork(buf, NetworkingUtils::readJsonObject);
            OnDrink[] actions = new OnDrink[objects.size()];
            for (int i = 0; i < actions.length; i++) {
                JsonObject actionObject = objects.get(i);
                OnDrinkTemplate template;
                try {
                    template = OnDrinkTemplate.get(new class_2960(class_3518.method_15265(actionObject, "type")));
                } catch (IllegalStateException ex) {
                    PDAPI.LOGGER.error("Could not load on drink action for add-in {} because of non-existent OnDrinkTemplate {}", id.toString(), class_3518.method_15265(actionObject, "type"), ex);
                    continue;
                }
                actions[i] = (template.parseJson(id, actionObject));
            }
            String name = buf.method_19772();
            return new SpecialtyDrink(id, class_7923.field_41178.method_10223(base), steps, actions, color, chemicals, name);
        }

        @Override
        public void toNetwork(class_2540 buf, SpecialtyDrink recipe) {
            buf.method_10812(class_7923.field_41178.method_10221(recipe.base));
            NetworkingUtils.arrayToNetwork(buf, recipe.steps, class_2540::method_10812);
            buf.method_34063(recipe.chemicals, class_2540::method_10814, class_2540::writeInt);
            buf.writeInt(recipe.color);
            JsonObject[] actions = NetworkingUtils.convertToJson(recipe.actions, OnDrink::toJson);
            NetworkingUtils.arrayToNetwork(buf, actions, NetworkingUtils::writeJsonObjectStart);
            buf.method_10814(recipe.name);
        }

    }

}
