package ml.pluto7073.pdapi.command;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import ml.pluto7073.pdapi.DrinkUtil;
import ml.pluto7073.pdapi.addition.chemicals.ConsumableChemicalHandler;
import ml.pluto7073.pdapi.addition.chemicals.ConsumableChemicalRegistry;
import ml.pluto7073.pdapi.gamerule.PDGameRules;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import java.util.Objects;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class PDCommands {

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder<class_2168> drink = method_9247("drink");
            ConsumableChemicalRegistry.forEach(handler -> {
                LiteralArgumentBuilder<class_2168> subCommand = handler.getDrinkSubcommand();
                if (subCommand == null) return;
                drink.then(subCommand);
            });
            dispatcher.register(drink);
        });
    }

    public static LiteralArgumentBuilder<class_2168> caffeine() {
        return method_9247("caffeine").then(caffeineGet()).then(caffeineSet());
    }

    private static LiteralArgumentBuilder<class_2168> caffeineGet() {
        return method_9247("get")
                .requires(source -> source.method_9259(2) || source.method_9225().method_8450().method_8355(PDGameRules.CAFFEINE_VISIBLE_TO_NON_OPS))
                .executes(ctx -> {
                    class_2168 source = ctx.getSource();
                    if (!source.method_43737()) {
                        source.method_9213(class_2561.method_43470("Must be executed by a player"));
                        return -1;
                    }
                    float caffeine = DrinkUtil.getPlayerCaffeine(source.method_9207());
                    source.method_9226(() -> class_2561.method_43469("command.getMyCaffeine.response", (int) caffeine), true);
                    return 1;
                }).then(method_9244("target", class_2186.method_9305()).requires(source -> source.method_9259(2))
                        .executes(ctx -> {
                            class_3222 target = class_2186.method_9315(ctx, "target");
                            ctx.getSource().method_9226(() -> class_2561.method_43469("command.getPlayerCaffeine.response", target.method_5477(), DrinkUtil.getPlayerCaffeine(target)), true);
                            return 1;
                        }));
    }

    private static LiteralArgumentBuilder<class_2168> caffeineSet() {
        return method_9247("set")
                .requires(source -> source.method_9259(2))
                .then(method_9244("target", class_2186.method_9305())
                        .then(method_9244("amount", IntegerArgumentType.integer(0))
                                .executes(context -> {
                                    class_3222 target = class_2186.method_9315(context, "target");
                                    int amount = IntegerArgumentType.getInteger(context, "amount");
                                    ConsumableChemicalRegistry.CAFFEINE.set(target, amount);
                                    return 1;
                                })));
    }

}
