package ml.pluto7073.pdapi.mixin;

import ml.pluto7073.pdapi.DrinkUtil;
import ml.pluto7073.pdapi.crossmodfeatures.CrossModFeatures;
import ml.pluto7073.pdapi.entity.PDTrackedData;
import ml.pluto7073.pdapi.entity.effect.PDMobEffects;
import ml.pluto7073.pdapi.gamerule.PDGameRules;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin extends PlayerEntityMixin {

    @Inject(at = @At("TAIL"), method = "readAdditionalSaveData")
    public void pdapi$readPlayerCaffeineData(class_2487 nbt, CallbackInfo ci) {
        class_2487 caffeineData;
        if (nbt.method_10545("CoffeeData")) {
            caffeineData = nbt.method_10562("CoffeeData");
        } else if (nbt.method_10545("CaffeineData")) {
            caffeineData = nbt.method_10562("CaffeineData");
        } else return;

        // Caffeine Content
        if (caffeineData.method_10545("CaffeineContent")) {
            float caffeine = caffeineData.method_10583("CaffeineContent");
            this.entityData.method_12778(PDTrackedData.PLAYER_CAFFEINE_AMOUNT, caffeine);
        }

        // Original Caffeine Content (for math purposes)
        if (caffeineData.method_10545("OriginalCaffeineContent")) {
            float originalCaffeine = caffeineData.method_10583("OriginalCaffeineContent");
            this.entityData.method_12778(PDTrackedData.PLAYER_ORIGINAL_CAFFEINE_AMOUNT, originalCaffeine);
        }

        // Ticks Since Last Caffeine Change
        if (caffeineData.method_10545("TicksSinceLastCaffeine")) {
            int ticks = caffeineData.method_10550("TicksSinceLastCaffeine");
            this.entityData.method_12778(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE, ticks);
        }
    }

    @Inject(at = @At("TAIL"), method = "addAdditionalSaveData")
    public void pdapi$writePlayerCaffeineData(class_2487 nbt, CallbackInfo ci) {
        class_2487 caffeineData = new class_2487();

        // Caffeine Content
        float caffeine = this.entityData.method_12789(PDTrackedData.PLAYER_CAFFEINE_AMOUNT);
        caffeineData.method_10548("CaffeineContent", caffeine);

        // Original Caffeine Content (For math purposes)
        float originalCaffeine = this.entityData.method_12789(PDTrackedData.PLAYER_ORIGINAL_CAFFEINE_AMOUNT);
        caffeineData.method_10548("OriginalCaffeineContent", originalCaffeine);

        // Ticks Since Last Caffeine Change
        int ticks = this.entityData.method_12789(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE);
        caffeineData.method_10569("TicksSinceLastCaffeine", ticks);

        nbt.method_10566("CaffeineData", caffeineData);
    }

    @Inject(at = @At("TAIL"), method = "tick")
    public void pdapi$updateCaffeineContent(CallbackInfo ci) {
        int ticks = this.entityData.method_12789(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE);
        ticks++;
        float originalCaffeine = this.entityData.method_12789(PDTrackedData.PLAYER_ORIGINAL_CAFFEINE_AMOUNT);
        float newCaffeine = DrinkUtil.calculateCaffeineDecay(ticks, originalCaffeine);
        this.entityData.method_12778(PDTrackedData.PLAYER_CAFFEINE_AMOUNT, newCaffeine);
        this.entityData.method_12778(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE, ticks);
    }

    @Inject(at = @At("TAIL"), method = "tick")
    public void pdapi$caffeineLevelEffects(CallbackInfo ci) {
        float caffeine = this.entityData.method_12789(PDTrackedData.PLAYER_CAFFEINE_AMOUNT);

        if (caffeine >= 100) {
            this.addEffect(new class_1293(class_1294.field_5904, 600));
        }
        if (caffeine >= 150) {
            this.addEffect(new class_1293(class_1294.field_5917, 600));
        }
        if (caffeine >= 300) {
            this.addEffect(new class_1293(class_1294.field_5903, 600));
        }
        if (caffeine >= 400) {
            CrossModFeatures.dehydration$AddThirstStatusEffect((class_3222) (Object) this, 600, 0, false);
        }
        if (caffeine >= 450) {
            this.addEffect(new class_1293(class_1294.field_5904, 600, 1));
        }
        if (caffeine >= 500) {
            this.addEffect(new class_1293(class_1294.field_5913, 600));
        }
        if (caffeine >= 600) {
            this.addEffect(new class_1293(class_1294.field_5917, 600, 1));
        }
        if (caffeine >= 700) {
            this.addEffect(new class_1293(class_1294.field_5913, 600, 1));
        }
        int lethalCaffeineDose = level().method_8450().method_8356(PDGameRules.LETHAL_CAFFEINE_DOSE);
        boolean overdose = level().method_8450().method_8355(PDGameRules.DO_CAFFEINE_OVERDOSE);
        if (overdose && caffeine >= lethalCaffeineDose) {
            this.addEffect(new class_1293(PDMobEffects.CAFFEINE_OVERDOSE, 20 * 60));
        }
    }

}
