/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.addition;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.addition.OnDrink;
import ml.pluto7073.pdapi.networking.packet.s2c.SyncAdditionRegistryS2CPacket;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class DrinkAdditions {
    private static final Map<class_2960, DrinkAddition> REGISTRY = new HashMap<class_2960, DrinkAddition>();
    private static final Map<class_2960, DrinkAddition> STATIC_REGISTRY = new HashMap<class_2960, DrinkAddition>();
    public static final String ADDITIONS_NBT_KEY = "Additions";
    public static final DrinkAddition EMPTY = DrinkAdditions.register(PDAPI.asId("empty"), new DrinkAddition(new OnDrink[0], false, 0, 0, 0, new JsonObject()));

    public static DrinkAddition register(class_2960 id, DrinkAddition addition) {
        return DrinkAdditions.register(id, addition, true);
    }

    public static DrinkAddition register(class_2960 id, DrinkAddition addition, boolean staticAdd) {
        if (DrinkAdditions.containsId(id) && DrinkAdditions.get(id).getCurrentWeight() >= addition.getCurrentWeight()) {
            return DrinkAdditions.get(id);
        }
        REGISTRY.put(id, addition);
        if (staticAdd) {
            STATIC_REGISTRY.put(id, addition);
        }
        return addition;
    }

    public static class_2960 getId(DrinkAddition addition) {
        for (Map.Entry<class_2960, DrinkAddition> entry : REGISTRY.entrySet()) {
            if (!addition.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Unregistered drink addition: " + addition.toString());
    }

    public static DrinkAddition get(class_2960 id) {
        return REGISTRY.get(id);
    }

    public static void resetRegistry() {
        REGISTRY.clear();
        REGISTRY.putAll(STATIC_REGISTRY);
    }

    public static boolean containsId(class_2960 id) {
        return REGISTRY.containsKey(id);
    }

    public static boolean containsAddition(DrinkAddition addition) {
        return REGISTRY.containsValue(addition);
    }

    public static boolean contains(class_2960 id, DrinkAddition addition) {
        return DrinkAdditions.containsId(id) && DrinkAdditions.containsAddition(addition) && DrinkAdditions.get(id).equals(addition);
    }

    public static boolean contains(Map.Entry<class_2960, DrinkAddition> entry) {
        return DrinkAdditions.contains(entry.getKey(), entry.getValue());
    }

    public static void send(class_3222 entity) {
        HashMap<class_2960, JsonObject> additions = new HashMap<class_2960, JsonObject>();
        REGISTRY.forEach((id, add) -> additions.put((class_2960)id, add.asJsonObject()));
        ServerPlayNetworking.send((class_3222)entity, (FabricPacket)new SyncAdditionRegistryS2CPacket(additions));
    }
}

