/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.specialty;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import ml.pluto7073.pdapi.DrinkUtil;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.addition.OnDrink;
import ml.pluto7073.pdapi.addition.OnDrinkTemplate;
import ml.pluto7073.pdapi.item.PDItems;
import ml.pluto7073.pdapi.networking.NetworkingUtils;
import ml.pluto7073.pdapi.recipes.PDRecipeTypes;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_6328;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@class_6328
public record SpecialtyDrink(class_2960 id, class_1792 base, class_2960[] steps, OnDrink[] actions, int color, int caffeine, String name) implements class_1860<class_1263>
{
    public static final HashMap<class_2960, SpecialtyDrink> DRINKS = new HashMap();

    public SpecialtyDrink(class_2960 id, class_1792 base, class_2960[] steps, OnDrink[] actions, int color, int caffeine, @Nullable String name) {
        this.id = id;
        this.base = base;
        this.steps = steps;
        this.actions = actions;
        this.color = color;
        this.caffeine = caffeine;
        this.name = name != null ? name : "drink." + id.method_12836() + "." + id.method_12832();
        DRINKS.put(id, this);
    }

    public class_1799 getAsItem() {
        return DrinkUtil.setSpecialDrink(new class_1799((class_1935)PDItems.SPECIALTY_DRINK, 1), this);
    }

    public class_1799 getAsOriginalItemWithAdditions(class_1799 source) {
        class_1799 stack = new class_1799((class_1935)this.base, 1);
        class_2487 ogData = source.method_7911("DrinkData");
        class_2487 drinkData = ogData.method_10553();
        class_2499 list = new class_2499();
        for (class_2960 step : this.steps) {
            list.add((Object)class_2519.method_23256((String)step.toString()));
        }
        list.addAll((Collection)ogData.method_10554("Additions", 8));
        drinkData.method_10566("Additions", (class_2520)list);
        stack.method_7948().method_10566("DrinkData", (class_2520)drinkData);
        return stack;
    }

    public boolean method_8115(class_1263 container, class_1937 level) {
        class_1799 currentResult = container.method_5438(0);
        if (!currentResult.method_31574(this.base)) {
            return false;
        }
        class_2499 additions = currentResult.method_7911("DrinkData").method_10554("Additions", 8);
        if (this.steps.length != additions.size()) {
            return false;
        }
        for (int i = 0; i < additions.size(); ++i) {
            String wanted;
            String actual = additions.method_10608(i);
            if (actual.equals(wanted = this.steps[i].toString())) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_8116(class_1263 container, class_5455 registryAccess) {
        return this.getAsItem();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.getAsItem();
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return PDRecipeTypes.SPECIALTY_DRINK_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return PDRecipeTypes.SPECIALTY_DRINK_RECIPE_TYPE;
    }

    @class_6328
    public static class Serializer
    implements class_1865<SpecialtyDrink> {
        public SpecialtyDrink fromJson(class_2960 id, JsonObject data) {
            class_1792 base = (class_1792)class_7923.field_41178.method_10223(new class_2960(class_3518.method_15265((JsonObject)data, (String)"base")));
            JsonArray additionsJson = class_3518.method_15261((JsonObject)data, (String)"additions");
            ArrayList<class_2960> additions = new ArrayList<class_2960>();
            for (JsonElement e : additionsJson) {
                additions.add(new class_2960(e.getAsString()));
            }
            int caffeine = class_3518.method_15260((JsonObject)data, (String)"caffeine");
            int color = class_3518.method_15260((JsonObject)data, (String)"color");
            JsonArray actionsArray = class_3518.method_15261((JsonObject)data, (String)"onDrinkActions");
            ArrayList<OnDrink> actions = new ArrayList<OnDrink>();
            for (JsonElement e : actionsArray) {
                OnDrinkTemplate template;
                if (!e.isJsonObject()) {
                    PDAPI.LOGGER.warn("Non-JsonObject item in 'onDrinkActions' in Specialty file: {}", (Object)id);
                    continue;
                }
                JsonObject actionObject = e.getAsJsonObject();
                try {
                    template = OnDrinkTemplate.get(new class_2960(class_3518.method_15265((JsonObject)actionObject, (String)"type")));
                }
                catch (IllegalStateException ex) {
                    PDAPI.LOGGER.error("Could not load on drink action for add-in {} because of non-existent OnDrinkTemplate {}", (Object)id.toString(), (Object)class_3518.method_15265((JsonObject)actionObject, (String)"type"), (Object)ex);
                    continue;
                }
                actions.add(template.parseJson(id, actionObject));
            }
            String name = null;
            if (data.has("name")) {
                name = class_3518.method_15265((JsonObject)data, (String)"name");
            }
            return new SpecialtyDrink(id, base, additions.toArray(new class_2960[0]), actions.toArray(new OnDrink[0]), color, caffeine, name);
        }

        public SpecialtyDrink fromNetwork(class_2960 id, class_2540 buf) {
            class_2960 base = buf.method_10810();
            class_2960[] steps = NetworkingUtils.listFromNetwork(buf, class_2540::method_10810).toArray(new class_2960[0]);
            int caffeine = buf.readInt();
            int color = buf.readInt();
            List objects = NetworkingUtils.listFromNetwork(buf, NetworkingUtils::readJsonObject);
            OnDrink[] actions = new OnDrink[objects.size()];
            for (int i = 0; i < actions.length; ++i) {
                OnDrinkTemplate template;
                JsonObject actionObject = (JsonObject)objects.get(i);
                try {
                    template = OnDrinkTemplate.get(new class_2960(class_3518.method_15265((JsonObject)actionObject, (String)"type")));
                }
                catch (IllegalStateException ex) {
                    PDAPI.LOGGER.error("Could not load on drink action for add-in {} because of non-existent OnDrinkTemplate {}", (Object)id.toString(), (Object)class_3518.method_15265((JsonObject)actionObject, (String)"type"), (Object)ex);
                    continue;
                }
                actions[i] = template.parseJson(id, actionObject);
            }
            String name = buf.method_19772();
            return new SpecialtyDrink(id, (class_1792)class_7923.field_41178.method_10223(base), steps, actions, color, caffeine, name);
        }

        public void toNetwork(class_2540 buf, SpecialtyDrink recipe) {
            buf.method_10812(class_7923.field_41178.method_10221((Object)recipe.base));
            NetworkingUtils.arrayToNetwork(buf, recipe.steps, class_2540::method_10812);
            buf.writeInt(recipe.caffeine);
            buf.writeInt(recipe.color);
            JsonObject[] actions = NetworkingUtils.convertToJson(recipe.actions, OnDrink::toJson);
            NetworkingUtils.arrayToNetwork(buf, actions, NetworkingUtils::writeJsonObjectStart);
            buf.method_10814(recipe.name);
        }
    }
}

