package ml.pluto7073.pdapi.mixin;

import ml.pluto7073.pdapi.addition.chemicals.ConsumableChemicalRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin extends PlayerEntityMixin {

    @Inject(at = @At("TAIL"), method = "readAdditionalSaveData")
    public void pdapi$readPlayerChemicalData(class_2487 nbt, CallbackInfo ci) {
        ConsumableChemicalRegistry.forEach(handler -> handler.loadFromTag(this.entityData, nbt));
    }

    @Inject(at = @At("TAIL"), method = "addAdditionalSaveData")
    public void pdapi$writePlayerChemicalData(class_2487 nbt, CallbackInfo ci) {
        ConsumableChemicalRegistry.forEach(handler -> handler.saveToTag(this.entityData, nbt));
    }

    @Inject(at = @At("TAIL"), method = "tick")
    public void pdapi$tickChemicals(CallbackInfo ci) {
        ConsumableChemicalRegistry.forEach(handler -> handler.tickPlayer((class_1657) (Object) this));
    }

    @Inject(at = @At("TAIL"), method = "tick")
    public void pdapi$applyChemicalEffects(CallbackInfo ci) {
        ConsumableChemicalRegistry.forEach(handler -> {
            class_1657 player = (class_3222) (Object) this;
            float amount = handler.get(player);
            handler.getEffectsForAmount(amount, player).forEach(this::addEffect);
        });
    }

}
