package ml.pluto7073.pdapi.networking.packet.s2c;

import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import java.util.Map;

public record SyncAdditionRegistryS2CPacket(Map<class_2960, DrinkAddition> additions) implements FabricPacket {

    public static final PacketType<SyncAdditionRegistryS2CPacket> TYPE = PacketType.create(
            PDAPI.asId("s2c/sync_addition_registry"), SyncAdditionRegistryS2CPacket::read
    );

    private static SyncAdditionRegistryS2CPacket read(class_2540 buffer) {
        return new SyncAdditionRegistryS2CPacket(buffer.method_34067(class_2540::method_10810, DrinkAddition::fromNetwork));
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_34063(additions, class_2540::method_10812, (b, addition) -> addition.toNetwork(b));
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

}
