package ml.pluto7073.pdapi.networking.packet.clientbound;

import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.specialty.SpecialtyDrink;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import java.util.Map;

public record ClientboundSyncSpecialtyDrinkRegistryPacket(Map<class_2960, SpecialtyDrink> registry)
        implements FabricPacket {

    public static final PacketType<ClientboundSyncSpecialtyDrinkRegistryPacket> TYPE = PacketType.create(
            PDAPI.asId("clientbound/sync_specialty_drink_registry"),
            ClientboundSyncSpecialtyDrinkRegistryPacket::read
    );

    private static ClientboundSyncSpecialtyDrinkRegistryPacket read(class_2540 buf) {
        return new ClientboundSyncSpecialtyDrinkRegistryPacket(buf.method_34067(
                class_2540::method_10810,
                SpecialtyDrink::fromNetwork
        ));
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_34063(registry, class_2540::method_10812, (b, d) -> d.toNetwork(b));
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }
}
