package ml.pluto7073.pdapi.specialty;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6328;
import net.minecraft.class_7923;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.PDRegistries;
import ml.pluto7073.pdapi.addition.DrinkAdditionManager;
import ml.pluto7073.pdapi.addition.action.OnDrinkAction;
import ml.pluto7073.pdapi.addition.action.OnDrinkSerializer;
import ml.pluto7073.pdapi.addition.chemicals.ConsumableChemicalRegistry;
import ml.pluto7073.pdapi.item.AbstractCustomizableDrinkItem;
import ml.pluto7073.pdapi.item.PDItems;
import ml.pluto7073.pdapi.networking.NetworkingUtils;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@class_6328
public class SpecialtyDrink {

    private final class_2960 id;
    private final class_1792 base;
    private final class_2960[] steps;
    private final OnDrinkAction[] actions;
    private final int color;
    private final HashMap<String, Integer> chemicals;
    private final String name;

    public SpecialtyDrink(class_2960 id, class_1792 base, class_2960[] steps, OnDrinkAction[] actions, int color, HashMap<String, Integer> chemicals, @Nullable String name) {
        this.id = id;
        this.base = base;
        this.steps = steps;
        this.actions = actions;
        this.color = color;
        this.chemicals = chemicals;
        this.name = name != null ? name : id.method_42093("drink");
    }

    public String languageKey() {
        return id.method_42093("drink");
    }

    public class_2960 id() {
        return id;
    }

    public class_1792 base() {
        return base;
    }

    public class_1799 baseAsStack() {
        return new class_1799(base);
    }

    public class_2960[] steps() {
        return steps;
    }

    public OnDrinkAction[] actions() {
        return actions;
    }

    public int color() {
        return color;
    }

    public HashMap<String, Integer> chemicals() {
        return chemicals;
    }

    public String name() {
        return name;
    }

    public class_1799 getAsItem() {
        return DrinkUtil.setSpecialDrink(new class_1799(PDItems.SPECIALTY_DRINK, 1), this);
    }

    public class_1799 getAsOriginalItemWithAdditions(class_1799 source) {
        class_1799 stack = baseAsStack();
        class_2487 ogData = source.method_7911(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY);
        class_2487 drinkData = ogData.method_10553();
        class_2499 list = new class_2499();
        for (class_2960 step : steps) {
            list.add(class_2519.method_23256(step.toString()));
        }
        list.addAll(ogData.method_10554(DrinkAdditionManager.ADDITIONS_NBT_KEY, class_2520.field_33258));
        drinkData.method_10566(DrinkAdditionManager.ADDITIONS_NBT_KEY, list);
        stack.method_7948().method_10566(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY, drinkData);
        return stack;
    }

    public boolean matches(class_1263 container) {
        class_1799 currentResult = container.method_5438(0);
        if (!currentResult.method_31574(base)) return false;
        class_2499 additions = currentResult.method_7911(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY)
                .method_10554(DrinkAdditionManager.ADDITIONS_NBT_KEY, class_2519.field_33258);
        if (steps.length != additions.size()) return false;
        for (int i = 0; i < additions.size(); i++) {
            String actual = additions.method_10608(i);
            String wanted = steps[i].toString();
            if (!actual.equals(wanted)) return false;
        }
        return true;
    }

    public class_2960 getId() {
        return id;
    }

    public List<class_1856> stepsToIngredientList() {
        List<class_1856> ingredients = new ArrayList<>();
        for (class_2960 addition : steps) {
            ingredients.add(DrinkUtil.additionToIngredient(addition));
        }
        return ingredients;
    }

    public void toNetwork(class_2540 buf) {
        buf.method_10812(id);
        buf.method_10812(class_7923.field_41178.method_10221(base));
        NetworkingUtils.arrayToNetwork(buf, steps, class_2540::method_10812);
        buf.method_34063(chemicals, class_2540::method_10814, class_2540::writeInt);
        buf.writeInt(color);
        NetworkingUtils.writeDrinkActionsList(buf, actions);
        buf.method_10814(name);
    }

    public static SpecialtyDrink fromJson(class_2960 id, JsonObject data) {
        class_1792 base = class_7923.field_41178.method_10223(new class_2960(class_3518.method_15265(data, "base")));
        JsonArray additionsJson = class_3518.method_15261(data, "additions");
        List<class_2960> additions = new ArrayList<>();
        for (JsonElement e : additionsJson) {
            additions.add(new class_2960(e.getAsString()));
        }
        if (additions.size() > 15) throw new IllegalStateException("Specialty Drink \"" + id.toString() + "\" cannot have more than 15 steps");

        HashMap<String, Integer> chemicals = new HashMap<>();
        ConsumableChemicalRegistry.forEach(handler -> {
            if (data.has(handler.getName())) {
                chemicals.put(handler.getName(), class_3518.method_15260(data, handler.getName()));
            }
        });

        int color = class_3518.method_15260(data, "color");
        JsonArray actionsArray = class_3518.method_15261(data, "onDrinkActions");
        List<OnDrinkAction> actions = new ArrayList<>();
        for (JsonElement e : actionsArray) {
            if (!e.isJsonObject()) {
                PDAPI.LOGGER.warn("Non-JsonObject item in 'onDrinkActions' in Specialty file: {}", id);
                continue;
            }
            JsonObject actionObject = e.getAsJsonObject();
            class_2960 type = new class_2960(class_3518.method_15265(actionObject, "type"));
            @SuppressWarnings("unchecked")
            OnDrinkSerializer<OnDrinkAction> serializer = (OnDrinkSerializer<OnDrinkAction>)
                    PDRegistries.ON_DRINK_SERIALIZER.method_10223(type);
            if (serializer == null) throw new IllegalArgumentException("Unknown OnDrinkAction " + type);
            actions.add(serializer.fromJson(actionObject));
        }
        String name = null;
        if (data.has("name")) {
            name = class_3518.method_15265(data, "name");
        }
        return new SpecialtyDrink(id, base, additions.toArray(new class_2960[0]), actions.toArray(new OnDrinkAction[0]), color, chemicals, name);
    }

    public static SpecialtyDrink fromNetwork(class_2540 buf) {
        class_2960 id = buf.method_10810();
        class_2960 base = buf.method_10810();
        class_2960[] steps = NetworkingUtils.listFromNetwork(buf, class_2540::method_10810).toArray(new class_2960[0]);
        HashMap<String, Integer> chemicals = Maps.newHashMap(buf.method_34067(class_2540::method_19772, class_2540::readInt));
        int color = buf.readInt();
        List<OnDrinkAction> list = NetworkingUtils.readDrinkActionsList(buf);
        String name = buf.method_19772();
        return new SpecialtyDrink(id, class_7923.field_41178.method_10223(base), steps, list.toArray(OnDrinkAction[]::new), color, chemicals, name);
    }

}
