package ml.pluto7073.pdapi.specialty;

import com.google.gson.JsonObject;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.networking.packet.clientbound.ClientboundSyncSpecialtyDrinkRegistryPacket;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.*;

public class SpecialtyDrinkManager implements SimpleSynchronousResourceReloadListener {

    private static final HashMap<class_2960, SpecialtyDrink> DRINKS = new HashMap<>();

    public static final class_2960 PHASE = PDAPI.asId("phase/specialty_drinks");
    public static final List<class_2960> DEPENDENCIES = new ArrayList<>();

    public SpecialtyDrinkManager() {
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(PHASE, (player, joined) ->
                ServerPlayNetworking.send(player, new ClientboundSyncSpecialtyDrinkRegistryPacket(DRINKS)));
    }

    @Override
    public class_2960 getFabricId() {
        return PDAPI.asId("specialty_drinks");
    }

    @Override
    public void method_14491(class_3300 manager) {
        DRINKS.clear();

        for (Map.Entry<class_2960, class_3298> entry :
                manager.method_14488("specialty_drinks", id -> id.method_12832().endsWith(".json")).entrySet()) {
            class_2960 id = DrinkUtil.getAsId(entry.getKey(), "specialty_drinks");
            try (InputStream stream = entry.getValue().method_14482()) {
                JsonObject object = class_3518.method_15255(new InputStreamReader(stream));

                if (object.has("fabric:load_conditions")) {
                    boolean b = ResourceConditions.conditionsMatch(
                            class_3518.method_15261(object, "fabric:load_conditions"),
                            true
                    );

                    if (!b) continue;
                }

                DRINKS.put(id, SpecialtyDrink.fromJson(id, object));
            } catch (IOException e) {
                PDAPI.LOGGER.error("Couldn't load Specialty Drink {}", id, e);
            }
        }

        PDAPI.LOGGER.info("Loaded {} Specialty Drinks", DRINKS.size());
    }

    @Override
    public Collection<class_2960> getFabricDependencies() {
        return DEPENDENCIES;
    }

    public static void register(class_2960 id, SpecialtyDrink drink) {
        DRINKS.put(id, drink);
    }

    public static SpecialtyDrink get(class_2960 id) {
        return DRINKS.get(id);
    }

    public static class_2960 getId(SpecialtyDrink drink) {
        for (class_2960 id : DRINKS.keySet()) {
            if (drink.equals(DRINKS.get(id))) return id;
        }
        return new class_2960("empty");
    }

    public static Collection<SpecialtyDrink> values() {
        return DRINKS.values();
    }

    public static void reset() {
        DRINKS.clear();
    }

}
