package ml.pluto7073.pdapi.crossmodfeatures.rei.display;

import com.google.common.collect.Lists;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import ml.pluto7073.pdapi.crossmodfeatures.rei.DrinkREI;
import ml.pluto7073.pdapi.specialty.InProgressItemRegistry;
import ml.pluto7073.pdapi.specialty.SpecialtyDrink;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class IngredientSequenceDisplay extends BasicDisplay {

    public IngredientSequenceDisplay(SpecialtyDrink drink) {
        super(EntryIngredients.ofIngredients(class_156.method_656(() -> {
            class_1792 base = drink.base();
            if (InProgressItemRegistry.isInProgressItem(base)) {
                base = InProgressItemRegistry.getBase(base);
            }
            List<class_1856> list = Lists.newArrayList(class_1856.method_8091(base));
            list.addAll(drink.stepsToIngredientList());
            return list;
        })), Collections.singletonList(EntryIngredients.of(drink.getAsItem())), Optional.of(drink.id()));
    }

    public IngredientSequenceDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_2960> id) {
        super(inputs, outputs, id);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return DrinkREI.INGREDIENT_SEQUENCE;
    }

}
