/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public final class JsonBuilder {
    private JsonBuilder() {
    }

    public static ObjectBuilder object() {
        return new ObjectBuilder();
    }

    public static ArrayBuilder array() {
        return new ArrayBuilder();
    }

    public static JsonArray createFabricModLoadedConditions(String ... requiredMods) {
        JsonArray mods = new JsonArray();
        for (String mod : requiredMods) {
            mods.add(mod);
        }
        return JsonBuilder.array().add(JsonBuilder.object().put("condition", "fabric:all_mods_loaded").put("values", (JsonElement)mods)).build();
    }

    public static class ObjectBuilder {
        private final JsonObject object = new JsonObject();

        private ObjectBuilder() {
        }

        public ObjectBuilder put(String key, JsonElement element) {
            this.object.add(key, element);
            return this;
        }

        public ObjectBuilder put(String key, ObjectBuilder builder) {
            return this.put(key, (JsonElement)builder.build());
        }

        public ObjectBuilder put(String key, ArrayBuilder builder) {
            return this.put(key, (JsonElement)builder.build());
        }

        public ObjectBuilder put(String key, String element) {
            this.object.addProperty(key, element);
            return this;
        }

        public ObjectBuilder put(String key, Number element) {
            this.object.addProperty(key, element);
            return this;
        }

        public ObjectBuilder put(String key, boolean element) {
            this.object.addProperty(key, Boolean.valueOf(element));
            return this;
        }

        public ObjectBuilder put(String key, char element) {
            this.object.addProperty(key, Character.valueOf(element));
            return this;
        }

        public JsonObject build() {
            return this.object;
        }
    }

    public static class ArrayBuilder {
        private final JsonArray array = new JsonArray();

        private ArrayBuilder() {
        }

        public ArrayBuilder add(JsonElement e) {
            this.array.add(e);
            return this;
        }

        public ArrayBuilder add(String s) {
            this.array.add(s);
            return this;
        }

        public ArrayBuilder add(Number n) {
            this.array.add(n);
            return this;
        }

        public ArrayBuilder add(boolean b) {
            this.array.add(Boolean.valueOf(b));
            return this;
        }

        public ArrayBuilder add(char c) {
            this.array.add(Character.valueOf(c));
            return this;
        }

        public ArrayBuilder add(ObjectBuilder b) {
            return this.add((JsonElement)b.build());
        }

        public ArrayBuilder add(ArrayBuilder b) {
            return this.add((JsonElement)b.build());
        }

        public JsonArray build() {
            return this.array;
        }
    }
}

