/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.specialty;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.PDRegistries;
import ml.pluto7073.pdapi.addition.action.OnDrinkAction;
import ml.pluto7073.pdapi.addition.action.OnDrinkSerializer;
import ml.pluto7073.pdapi.addition.chemicals.ConsumableChemicalRegistry;
import ml.pluto7073.pdapi.item.PDItems;
import ml.pluto7073.pdapi.networking.NetworkingUtils;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkSerializer;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6328;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@class_6328
public class SpecialtyDrink {
    private final class_2960 id;
    private final class_1792 base;
    private final class_2960[] steps;
    private final OnDrinkAction[] actions;
    private final int color;
    private final HashMap<String, Integer> chemicals;
    private final String name;

    public SpecialtyDrink(class_2960 id, class_1792 base, class_2960[] steps, OnDrinkAction[] actions, int color, HashMap<String, Integer> chemicals, @Nullable String name) {
        this.id = id;
        this.base = base;
        this.steps = steps;
        this.actions = actions;
        this.color = color;
        this.chemicals = chemicals;
        this.name = name != null ? name : id.method_42093("drink");
    }

    public String languageKey() {
        return this.id.method_42093("drink");
    }

    public class_2960 id() {
        return this.id;
    }

    public class_1792 base() {
        return this.base;
    }

    public class_1799 baseAsStack() {
        return new class_1799((class_1935)this.base);
    }

    public class_2960[] steps() {
        return this.steps;
    }

    public OnDrinkAction[] actions() {
        return this.actions;
    }

    public int color() {
        return this.color;
    }

    public HashMap<String, Integer> chemicals() {
        return this.chemicals;
    }

    public String name() {
        return this.name;
    }

    public class_2960 type() {
        return PDAPI.asId("specialty_drink");
    }

    public SpecialtyDrinkSerializer serializer() {
        return SpecialtyDrinkSerializer.DEFAULT_SERIALIZER;
    }

    public class_1799 getAsItem() {
        return DrinkUtil.setSpecialDrink(new class_1799((class_1935)PDItems.SPECIALTY_DRINK, 1), this);
    }

    public class_1799 getAsOriginalItemWithAdditions(class_1799 source) {
        class_1799 stack = this.baseAsStack();
        class_2487 ogData = source.method_7911("DrinkData");
        class_2487 drinkData = ogData.method_10553();
        class_2499 list = new class_2499();
        for (class_2960 step : this.steps) {
            list.add((Object)class_2519.method_23256((String)step.toString()));
        }
        list.addAll((Collection)ogData.method_10554("Additions", 8));
        drinkData.method_10566("Additions", (class_2520)list);
        stack.method_7948().method_10566("DrinkData", (class_2520)drinkData);
        return stack;
    }

    public boolean matches(class_1263 container) {
        class_1799 currentResult = container.method_5438(0);
        if (!currentResult.method_31574(this.base)) {
            return false;
        }
        class_2499 additions = currentResult.method_7911("DrinkData").method_10554("Additions", 8);
        if (this.steps.length != additions.size()) {
            return false;
        }
        for (int i = 0; i < additions.size(); ++i) {
            String wanted;
            String actual = additions.method_10608(i);
            if (actual.equals(wanted = this.steps[i].toString())) continue;
            return false;
        }
        return true;
    }

    public class_2960 getId() {
        return this.id;
    }

    public List<class_1856> stepsToIngredientList() {
        ArrayList<class_1856> ingredients = new ArrayList<class_1856>();
        for (class_2960 addition : this.steps) {
            ingredients.add(DrinkUtil.additionToIngredient(addition));
        }
        return ingredients;
    }

    public void toNetwork(class_2540 buf) {
        buf.method_10812(this.id);
        buf.method_10812(class_7923.field_41178.method_10221((Object)this.base));
        NetworkingUtils.arrayToNetwork(buf, this.steps, class_2540::method_10812);
        buf.method_34063(this.chemicals, class_2540::method_10814, class_2540::writeInt);
        buf.writeInt(this.color);
        NetworkingUtils.writeDrinkActionsList(buf, this.actions);
        buf.method_10814(this.name);
    }

    public static class BaseSerializer
    implements SpecialtyDrinkSerializer {
        @Override
        public SpecialtyDrink fromJson(class_2960 id, JsonObject data) {
            class_1792 base = (class_1792)class_7923.field_41178.method_10223(new class_2960(class_3518.method_15265((JsonObject)data, (String)"base")));
            JsonArray additionsJson = class_3518.method_15261((JsonObject)data, (String)"additions");
            ArrayList<class_2960> additions = new ArrayList<class_2960>();
            for (JsonElement e : additionsJson) {
                additions.add(new class_2960(e.getAsString()));
            }
            if (DrinkUtil.condense(additions).size() > 15) {
                throw new IllegalStateException("Specialty Drink \"" + id.toString() + "\" cannot have more than 15 steps");
            }
            HashMap<String, Integer> chemicals = new HashMap<String, Integer>();
            ConsumableChemicalRegistry.forEach(handler -> {
                if (data.has(handler.getName())) {
                    chemicals.put(handler.getName(), class_3518.method_15260((JsonObject)data, (String)handler.getName()));
                }
            });
            int color = class_3518.method_15260((JsonObject)data, (String)"color");
            JsonArray actionsArray = class_3518.method_15261((JsonObject)data, (String)"onDrinkActions");
            ArrayList actions = new ArrayList();
            for (JsonElement e : actionsArray) {
                if (!e.isJsonObject()) {
                    PDAPI.LOGGER.warn("Non-JsonObject item in 'onDrinkActions' in Specialty file: {}", (Object)id);
                    continue;
                }
                JsonObject actionObject = e.getAsJsonObject();
                class_2960 type = new class_2960(class_3518.method_15265((JsonObject)actionObject, (String)"type"));
                OnDrinkSerializer serializer = (OnDrinkSerializer)PDRegistries.ON_DRINK_SERIALIZER.method_10223(type);
                if (serializer == null) {
                    throw new IllegalArgumentException("Unknown OnDrinkAction " + String.valueOf(type));
                }
                actions.add(serializer.fromJson(actionObject));
            }
            String name = null;
            if (data.has("name")) {
                name = class_3518.method_15265((JsonObject)data, (String)"name");
            }
            return new SpecialtyDrink(id, base, additions.toArray(new class_2960[0]), actions.toArray(new OnDrinkAction[0]), color, chemicals, name);
        }

        @Override
        public SpecialtyDrink fromNetwork(class_2540 buf) {
            class_2960 id = buf.method_10810();
            class_2960 base = buf.method_10810();
            class_2960[] steps = NetworkingUtils.listFromNetwork(buf, class_2540::method_10810).toArray(new class_2960[0]);
            HashMap chemicals = Maps.newHashMap((Map)buf.method_34067(class_2540::method_19772, class_2540::readInt));
            int color = buf.readInt();
            List<OnDrinkAction> list = NetworkingUtils.readDrinkActionsList(buf);
            String name = buf.method_19772();
            return new SpecialtyDrink(id, (class_1792)class_7923.field_41178.method_10223(base), steps, (OnDrinkAction[])list.toArray(OnDrinkAction[]::new), color, chemicals, name);
        }

        @Override
        public void toNetwork(SpecialtyDrink drink, class_2540 buf) {
            drink.toNetwork(buf);
        }
    }
}

